/*
 * lxdata-a.0.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <e4-m.0.h>
#include <e4.h>
#include <lxcall.h>
#include <lxdata-defs.h>
#include <lxdata-inter.h>
#include <lxdata-types.h>

#define MAKE_SINGLE(a, b)		a

#define fb_size()			1

#define screen(screen) \
    ((struct screen_type *) (screen))

#define f1_size(year) \
    (year)

#define fa_size(year) \
    ((year) * sizeof(int))

#define ff_size(year) \
    ((year) * sizeof(struct x1f4_linetext_type))

static int init_data(struct lxdata_type *, unsigned,
		     const struct screen_type *);
static int line_data(struct lxdata_type *, unsigned,
		     const struct screen_type *);
static int line_text(struct lxdata_type *, unsigned,
		     const struct screen_type *, void *, void **, void **);
static int link_data(struct lxdata_type *, unsigned,
		     const struct screen_type *);

static void line_afix(u_case_args_____0);
static void line_aset(u_case_args_____0);
static void line_bfix(u_case_args_____0);
static void line_bset(u_case_args_____0);
static void line_cfix(u_case_args_____0);
static void line_cmap(u_case_args_____0);
static void line_cset(u_case_args_____0);
static void line_cway(u_case_args_____0);
static void line_dfix(u_case_args_____0);
static void line_dsub(u_case_args_____0);
static void line_efix(u_case_args_____0);
static void line_emap(u_case_args_____0);
static void line_eway(u_case_args_____0);
static void line_ffix(u_case_args_____0);
static void line_fset(u_case_args_____0);
static void line_fway(u_case_args_____0);
static void line_ifix(u_case_args_____0);
static void line_iset(u_case_args_____0);
static void line_lfix(u_case_args_____0);
static void line_lmap(u_case_args_____0);
static void line_nset(u_case_args_____0);
static void line_pfix(u_case_args_____0);
static void line_pmap(u_case_args_____0);
static void line_pway(u_case_args_____0);
static void line_rfar(u_case_args_____0);
static void line_rfix(u_case_args_____0);
static void line_rset(u_case_args_____0);
static void line_rway(u_case_args_____0);
static void line_sfar(u_case_args_____0);
static void line_sfix(u_case_args_____0);
static void line_sled(u_case_args_____0);
static void line_smap(u_case_args_____0);
static void line_snew(u_case_args_____0);
static void line_srun(u_case_args_____0);
static void line_sset(u_case_args_____0);
static void line_ssub(u_case_args_____0);
static void line_stip(u_case_args_____0);
static void line_sway(u_case_args_____0);
static void line_tfix(u_case_args_____0);
static void line_tset(u_case_args_____0);
static void line_tway(u_case_args_____0);

static const char fb_setf[] = "b_set", *const side_f[] = {
/* *INDENT-OFF* */
    fb_setf
/* *INDENT-ON* */
};
static const struct line_type auto_line[] = {
/* *INDENT-OFF* */
#define b_project_count			2
    {	{	"b_project",
		_libx1f4i0_lxdata_p_derived,	X1f4_E4_TEXT,
		NULL,				b_project_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						9		},
	line_pway,							},
#define b_project_reach			(0 + b_project_count)
#define b_string_count			1
    {	{	"b_string",
		_libx1f4i0_lxdata_s_logique,	X1f4_E4_TEXT,
		NULL,				b_string_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_sfix,							}
#define b_string_reach			(b_project_reach + b_string_count)
/* *INDENT-ON* */
#define auto_line_count			b_string_reach
}, call_line[] = {
/* *INDENT-OFF* */
#define b_new_count			1
    {	{	"b_new",
		_libx1f4i0_lxdata_n_forward,	X1f4_E4_VOID,
		NULL,				b_new_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_nset,							}
#define b_new_reach			(0 + (b_new_count << 1))
/* *INDENT-ON* */
#define call_line_count			b_new_reach
}, ever_line[] = {
/* *INDENT-OFF* */
#define b_set_count			2
    {	{	fb_setf,
		_libx1f4i0_lxdata_s_pending,	0,
		NULL,				b_set_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_POST_TYPE
		| X1f4_E4_TEXT_LINK,
						5		},
	line_smap,							}
#define b_set_reach			(0 + (b_set_count << 1))
/* *INDENT-ON* */
#define ever_line_count			b_set_reach
}, slip_line[] = {
/* *INDENT-OFF* */
#define b_add_count			2
    {	{	"b_add",
		_libx1f4i0_lxdata_a_forward,	X1f4_E4_VOID,
		NULL,				b_add_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_aset,							},
#define b_add_reach			(0 + b_add_count)
#define b_append_count			2
    {	{	"b_append",
		_libx1f4i0_lxdata_a_logique,	X1f4_E4_VOID,
		NULL,				b_append_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_afix,							},
#define b_append_reach			(b_add_reach + b_append_count)
#define b_bill_count			4
    {	{	"b_bill",
		_libx1f4i0_lxdata_b_logique,	X1f4_E4_VOID,
		NULL,				b_bill_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_bfix,							},
#define b_bill_reach			(b_append_reach + b_bill_count)
#define b_cast_count			2
    {	{	"b_cast",
		_libx1f4i0_lxdata_c_forward,	X1f4_E4_VOID,
		NULL,				b_cast_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_cset,							},
#define b_cast_reach			(b_bill_reach + b_cast_count)
#define b_character_count		2
    {	{	"b_character",
		_libx1f4i0_lxdata_t_logique,	X1f4_E4_MODE,
		NULL,				b_character_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						11		},
	line_tfix,							},
#define b_character_reach		(b_cast_reach + b_character_count)
#define b_clear_count			1
    {	{	"b_clear",
		_libx1f4i0_lxdata_c_logique,	X1f4_E4_VOID,
		NULL,				b_clear_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_cfix,							},
#define b_clear_reach			(b_character_reach + b_clear_count)
#define b_compare_count			2
    {	{	"b_compare",
		_libx1f4i0_lxdata_c_derived,	X1f4_E4_MODE,
		NULL,				b_compare_count,
		0,				9		},
	line_cway,							},
#define b_compare_reach			(b_clear_reach + b_compare_count)
#define b_copy_count			2
    {	{	"b_copy",
		_libx1f4i0_lxdata_c_pending,	X1f4_E4_VOID,
		NULL,				b_copy_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_cmap,							},
#define b_copy_reach			(b_compare_reach + b_copy_count)
#define b_delete_count			2
    {	{	"b_delete",
		_libx1f4i0_lxdata_d_logique,	X1f4_E4_VOID,
		NULL,				b_delete_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_dfix,							},
#define b_delete_reach			(b_copy_reach + b_delete_count)
#define b_drop_count			2
    {	{	"b_drop",
		_libx1f4i0_lxdata_d_centric,	X1f4_E4_VOID,
		NULL,				b_drop_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_dsub,							},
#define b_drop_reach			(b_delete_reach + b_drop_count)
#define b_edit_count			3
    {	{	"b_edit",
		_libx1f4i0_lxdata_e_pending,	X1f4_E4_VOID,
		NULL,				b_edit_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_emap,							},
#define b_edit_reach			(b_drop_reach + b_edit_count)
#define b_erase_count			3
    {	{	"b_erase",
		_libx1f4i0_lxdata_e_logique,	X1f4_E4_VOID,
		NULL,				b_erase_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_efix,							},
#define b_erase_reach			(b_edit_reach + b_erase_count)
#define b_even_count			3
    {	{	"b_even",
		_libx1f4i0_lxdata_e_derived,	X1f4_E4_MODE,
		NULL,				b_even_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_eway,							},
#define b_even_reach			(b_erase_reach + b_even_count)
#define b_extend_count			2
    {	{	"b_extend",
		_libx1f4i0_lxdata_a_forward,	X1f4_E4_VOID,
		NULL,				b_extend_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_aset,							},
#define b_extend_reach			(b_even_reach + b_extend_count)
#define b_find_count			2
    {	{	"b_find",
		_libx1f4i0_lxdata_f_derived,	X1f4_E4_MODE,
		NULL,				b_find_count,
		0,				6		},
	line_fway,							},
#define b_find_reach			(b_extend_reach + b_find_count)
#define b_fit_count			2
    {	{	"b_fit",
		_libx1f4i0_lxdata_f_logique,	X1f4_E4_VOID,
		NULL,				b_fit_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						5		},
	line_ffix,							},
#define b_fit_reach			(b_find_reach + b_fit_count)
#define b_frame_count			2
    {	{	"b_frame",
		_libx1f4i0_lxdata_f_forward,	X1f4_E4_MODE,
		NULL,				b_frame_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_fset,							},
#define b_frame_reach			(b_fit_reach + b_frame_count)
#define b_index_count			2
    {	{	"b_index",
		_libx1f4i0_lxdata_i_forward,	X1f4_E4_MODE,
		NULL,				b_index_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_iset,							},
#define b_index_reach			(b_frame_reach + b_index_count)
#define b_insert_count			3
    {	{	"b_insert",
		_libx1f4i0_lxdata_i_logique,	X1f4_E4_VOID,
		NULL,				b_insert_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_ifix,							},
#define b_insert_reach			(b_index_reach + b_insert_count)
#define b_length_count			1
    {	{	"b_length",
		_libx1f4i0_lxdata_l_logique,	X1f4_E4_MODE,
		NULL,				b_length_count,
		0,				8		},
	line_lfix,							},
#define b_length_reach			(b_insert_reach + b_length_count)
#define b_look_count			3
    {	{	"b_look",
		_libx1f4i0_lxdata_l_pending,	X1f4_E4_MODE,
		NULL,				b_look_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_lmap,							},
#define b_look_reach			(b_length_reach + b_look_count)
#define b_paste_count			3
    {	{	"b_paste",
		_libx1f4i0_lxdata_p_logique,	X1f4_E4_VOID,
		NULL,				b_paste_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_pfix,							},
#define b_paste_reach			(b_look_reach + b_paste_count)
#define b_patch_count			3
    {	{	"b_patch",
		_libx1f4i0_lxdata_p_forward,	X1f4_E4_VOID,
		NULL,				b_patch_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_bset,							},
#define b_patch_reach			(b_paste_reach + b_patch_count)
#define b_probe_count			3
    {	{	"b_probe",
		_libx1f4i0_lxdata_p_pending,	X1f4_E4_MODE,
		NULL,				b_probe_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_pmap,							},
#define b_probe_reach			(b_patch_reach + b_probe_count)
#define b_rate_count			3
    {	{	"b_rate",
		_libx1f4i0_lxdata_r_sequent,	X1f4_E4_MODE,
		NULL,				b_rate_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_rfar,							},
#define b_rate_reach			(b_probe_reach + b_rate_count)
#define b_replace_count			3
    {	{	"b_replace",
		_libx1f4i0_lxdata_r_logique,	X1f4_E4_VOID,
		NULL,				b_replace_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						9		},
	line_rfix,							},
#define b_replace_reach			(b_rate_reach + b_replace_count)
#define b_reverse_count			1
    {	{	"b_reverse",
		_libx1f4i0_lxdata_r_derived,	X1f4_E4_VOID,
		NULL,				b_reverse_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						9		},
	line_rway,							},
#define b_reverse_reach			(b_replace_reach + b_reverse_count)
#define b_rule_count			5
    {	{	"b_rule",
		_libx1f4i0_lxdata_r_forward,	X1f4_E4_VOID,
		NULL,				b_rule_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_rset,							},
#define b_rule_reach			(b_reverse_reach + b_rule_count)
#define b_scan_count			3
    {	{	"b_scan",
		_libx1f4i0_lxdata_s_generic,	X1f4_E4_MODE,
		NULL,				b_scan_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_stip,							},
#define b_scan_reach			(b_rule_reach + b_scan_count)
#define b_scrap_count			3
    {	{	"b_scrap",
		_libx1f4i0_lxdata_s_nearest,	X1f4_E4_VOID,
		NULL,				b_scrap_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_srun,							},
#define b_scrap_reach			(b_scan_reach + b_scrap_count)
#define b_seek_count			2
    {	{	"b_seek",
		_libx1f4i0_lxdata_s_ongoing,	X1f4_E4_MODE,
		NULL,				b_seek_count,
		0,				6		},
	line_sled,							},
#define b_seek_reach			(b_scrap_reach + b_seek_count)
#define b_side_count			3
    {	{	"b_side",
		_libx1f4i0_lxdata_s_harsher,	X1f4_E4_MODE,
		NULL,				b_side_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_snew,							},
#define b_side_reach			(b_seek_reach + b_side_count)
#define b_size_count			2
    {	{	"b_size",
		_libx1f4i0_lxdata_s_derived,	X1f4_E4_VOID,
		NULL,				b_size_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_sway,							},
#define b_size_reach			(b_side_reach + b_size_count)
#define b_slip_count			2
    {	{	"b_slip",
		_libx1f4i0_lxdata_s_centric,	X1f4_E4_VOID,
		NULL,				b_slip_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						6		},
	line_ssub,							},
#define b_slip_reach			(b_size_reach + b_slip_count)
#define b_stock_count			3
    {	{	"b_stock",
		_libx1f4i0_lxdata_s_sequent,	X1f4_E4_VOID,
		NULL,				b_stock_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_sfar,							},
#define b_stock_reach			(b_slip_reach + b_stock_count)
#define b_suffix_count			2
    {	{	"b_suffix",
		_libx1f4i0_lxdata_f_logique,	X1f4_E4_VOID,
		NULL,				b_suffix_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						8		},
	line_ffix,							},
#define b_suffix_reach			(b_stock_reach + b_suffix_count)
#define b_swap_count			2
    {	{	"b_swap",
		_libx1f4i0_lxdata_s_forward,	X1f4_E4_VOID,
		NULL,				b_swap_count,
		X1f4_E4_KEEP_CALL,		6		},
	line_sset,							},
#define b_swap_reach			(b_suffix_reach + b_swap_count)
#define b_trace_count			3
    {	{	"b_trace",
		_libx1f4i0_lxdata_t_forward,	X1f4_E4_MODE,
		NULL,				b_trace_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						7		},
	line_tset,							},
#define b_trace_reach			(b_swap_reach + b_trace_count)
#define b_translate_count		3
    {	{	"b_translate",
		_libx1f4i0_lxdata_t_derived,	X1f4_E4_VOID,
		NULL,				b_translate_count,
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK,
						11		},
	line_tway,							}
#define b_translate_reach \
    (b_trace_reach + b_translate_count)
/* *INDENT-ON* */
#define slip_line_count			b_translate_reach
};
static const struct x1f4_operator_type side_o[] = {
/* *INDENT-OFF* */
    {	MAKE_SINGLE("=", " "),  NULL,		0400,
	0,			NULL,
	X1f4_E4_BACK_LINK | X1f4_E4_E2ND_LINK | X1f4_E4_LEFT_XSET,
				1,
	NULL,			NULL					}
/* *INDENT-ON* */
};

static int
init_data(struct lxdata_type *lxdata_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;

    if (bits & AUTOLINK_LINK) {
	lxdata_data->link_v.data = screen_data->link_v.data;
	lxdata_data->link_v.free = screen_data->link_v.free;
	lxdata_data->link_v.link = screen_data->link_v.link;
	lxdata_data->link_v.mode = screen_data->link_v.mode;
	lxdata_data->link_v.pick = screen_data->link_v.pick;
	lxdata_data->link_v.slip = screen_data->link_v.slip;
    } else {
	bits &= ~EVERLINK_SLIP;

	lxdata_data->link_v.data = NULL;
	lxdata_data->link_v.free = NULL;
	lxdata_data->link_v.link = NULL;
	lxdata_data->link_v.mode = NULL;
	lxdata_data->link_v.pick = NULL;
	lxdata_data->link_v.slip = NULL;
    }

    if (bits & CODELINK_LINK) {
	lxdata_data->link_w.data = screen_data->link_w.data;
	lxdata_data->link_w.free = screen_data->link_w.free;
	lxdata_data->link_w.link = screen_data->link_w.link;
	lxdata_data->link_w.mode = screen_data->link_w.mode;
    } else {
	lxdata_data->link_w.data = NULL;
	lxdata_data->link_w.free = _x1f4_e4_free_data;
	lxdata_data->link_w.link = _x1f4_e4_link_data;
	lxdata_data->link_w.mode = _x1f4_e4_mode_data;
    }

    if (bits & RESOURCE_LINK) {
	lxdata_data->link_m.data = screen_data->link_m.data;
	lxdata_data->link_m.free = screen_data->link_m.free;
	lxdata_data->link_m.link = screen_data->link_m.link;
	lxdata_data->link_m.mode = screen_data->link_m.mode;
    } else {
	lxdata_data->link_m.data = NULL;
	lxdata_data->link_m.free = _x1f4_e4_free_data;
	lxdata_data->link_m.link = _x1f4_e4_link_data;
	lxdata_data->link_m.mode = _x1f4_e4_mode_data;
    }

    if (bits & TEXTFLAT_LINK) {
	lxdata_data->link_e.data = screen_data->link_e.data;
	lxdata_data->link_e.line = screen_data->link_e.line;
	lxdata_data->link_e.post = screen_data->link_e.post;
	lxdata_data->link_e.push = screen_data->link_e.push;
    } else {
	lxdata_data->link_e.data = NULL;
	lxdata_data->link_e.line = NULL;
	lxdata_data->link_e.post = NULL;
	lxdata_data->link_e.push = NULL;
    }

    status = link_data(lxdata_data, bits, screen_data);

    return status;
}


static int
line_data(struct lxdata_type *lxdata_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    lxdata_data->link_t.datatype[0].context = lxdata_data;

    lxdata_data->link_t.datatype[0].flat = _libx1f4i0_lxdata_flat_data;
    lxdata_data->link_t.datatype[0].lead = _libx1f4i0_lxdata_lead_data;
    lxdata_data->link_t.datatype[0].line = _libx1f4i0_lxdata_line_data;
    lxdata_data->link_t.datatype[0].link = _libx1f4i0_lxdata_link_data;
    lxdata_data->link_t.datatype[0].name = "data";
    lxdata_data->link_t.datatype[0].shut = _libx1f4i0_lxdata_flat_data;
    lxdata_data->link_t.datatype[0].slip = _libx1f4i0_lxdata_slip_data;
    lxdata_data->link_t.datatype[0].size = 4;
    lxdata_data->link_t.datatype[0].type = screen_data->link_l.type;

    lxdata_data->link_t.datatype[1].context = NULL;

    lxdata_data->link_t.datatype[1].flat = NULL;
    lxdata_data->link_t.datatype[1].lead = NULL;
    lxdata_data->link_t.datatype[1].line = NULL;
    lxdata_data->link_t.datatype[1].link = NULL;
    lxdata_data->link_t.datatype[1].name = NULL;
    lxdata_data->link_t.datatype[1].shut = NULL;
    lxdata_data->link_t.datatype[1].slip = NULL;
    lxdata_data->link_t.datatype[1].size = 0;
    lxdata_data->link_t.datatype[1].type = 0;

    return 0;
}


static int
line_text(struct lxdata_type *lxdata_data, unsigned bits,
	  const struct screen_type *screen_data, void *data, void **args,
	  void **dana)
{
    struct x1f4_linetext_type *linetext_data;

    linetext_data = data;

    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxdata_data, bits, screen_data, linetext_data, args,
	     sizeof(slip_line) / sizeof(struct line_type), slip_line);
	linetext_data += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_side_line
	    (lxdata_data, bits, screen_data, linetext_data, args,
	     sizeof(call_line) / sizeof(struct line_type), call_line);
	linetext_data += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & AUTOLINK_LINK) {
	_libx1f4i0_lxcall_side_line
	    (lxdata_data, bits, screen_data, linetext_data, args,
	     sizeof(auto_line) / sizeof(struct line_type), auto_line);
	linetext_data += sizeof(auto_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	_libx1f4i0_lxcall_side_line
	    (lxdata_data, bits, screen_data, linetext_data, args,
	     sizeof(ever_line) / sizeof(struct line_type), ever_line);
	linetext_data += sizeof(ever_line) / sizeof(struct line_type);
    }
    if (1) {
	_libx1f4i0_lxcall_zero_line(linetext_data);
    }

    return 0;
}


static int
link_data(struct lxdata_type *lxdata_data, unsigned bits,
	  const struct screen_type *screen_data)
{
    int status;
    unsigned args_count, line_count;
    void *data;

    args_count = 0;
    line_count = 1;

    {
	args_count += slip_line_count;
	line_count += sizeof(slip_line) / sizeof(struct line_type);
    }
    if (1) {
	args_count += call_line_count;
	line_count += sizeof(call_line) / sizeof(struct line_type);
    }
    if (bits & AUTOLINK_LINK) {
	args_count += auto_line_count;
	line_count += sizeof(auto_line) / sizeof(struct line_type);
    }
    if (bits & EVERLINK_SLIP) {
	args_count += ever_line_count;
	line_count += sizeof(ever_line) / sizeof(struct line_type);
    }

    status = lxdata_data->link_w.link
	(lxdata_data->link_w.data, &data,
	 args_count * sizeof(int)
	 + line_count * sizeof(struct x1f4_linetext_type)
	 + (sizeof(struct tide_type) + sizeof(struct x1f4_operator_type *))
	 * fb_size() + sizeof(struct x1f4_operator_type *));
    if (status) {
	status = LINK_ERROR;
    } else {
	void *args, *dana, *side;

	side = (struct x1f4_linetext_type *) data + line_count;
	side = (struct tide_type *) side + fb_size();
	args = (struct x1f4_operator_type **) side + fb_size() + 1;

	lxdata_data->link_f.data = data;
	lxdata_data->link_f.side = side;

	line_text(lxdata_data, bits, screen_data, data, &args, &dana);
	_libx1f4i0_lxcall_line_side(side, data, side_o, side_f, fb_size());

	line_data(lxdata_data, bits, screen_data);
    }

    return status;
}


static void
line_afix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_aset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_bfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_BILL;

    *args = line;
}


static void
line_bset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_cfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_cset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_cway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_dfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_dsub(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_efix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_emap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_eway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_ffix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_fset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_fway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_ifix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_iset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_lfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_lmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_nset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;

    *args = line;
}


static void
line_pfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_pmap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_pway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_rfar(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_rfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_rset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_BILL;

    *args = line;
}


static void
line_rway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_sfar(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_sfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_sled(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_smap(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_POST_XSET;
    *line++ = 0;

    *args = line;

    linetext_data->function.type = screen(screen)->link_l.type;
}


static void
line_snew(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


static void
line_srun(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_BILL;

    *args = line;
}


static void
line_sset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_ssub(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_stip(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = screen(screen)->link_l.type;

    *args = line;
}


static void
line_sway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_tfix(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_tset(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_MODE;
    *line++ = X1f4_E4_MODE;

    *args = line;
}


static void
line_tway(u_case_args_____1)
{
    int *line;

    line = *args;

    linetext_data->function.args = line;

    *line++ = screen(screen)->link_l.type;
    *line++ = X1f4_E4_TEXT;
    *line++ = X1f4_E4_TEXT;

    *args = line;
}


int
x1f4_init_lxdata(void **lxdata, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *data, *text;

    if (bits & CODELINK_LINK) {
	link = screen_data->link_w.link;
	text = screen_data->link_w.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &data, sizeof(struct lxdata_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	status = init_data(data, bits, screen_data);
	if (status) {
	    if (bits & CODELINK_LINK) {
		screen_data->link_w.free(text, data);
	    } else {
		_x1f4_e4_free_data(text, data);
	    }
	} else {
	    *lxdata = data;
	}
    }

    return status;
}
