/*
 * lxcast-types.h
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxcast_types_H__
#define __LIBx1f4_lxcast_types_H__

#include <lxcast-config.h>

#include <dt.h>
#include <frame.h>
#include <e4.h>
#include <ln.h>
#include <nt.h>
#include <track.h>
#include <trans.h>

typedef struct dxcast_type {
    int call, type;
    union {
	X1f4_E4_C_BILL bill;
	X1f4_E4_C_MODE mode;
	X1f4_E4_C_REAL real;
	X1f4_E4_C_TEXT text;
	X1f4_E4_C_USER user;
    } data;
} dxcast_type;

typedef struct fringe_type {
    struct fringe_type *fringe_data;
    struct x1f4_linetext_type linetext;
} fringe_type;

/*
 * NOTES
 *
 *.there may be a need for a temporary memory allocator in addition to the
 * permanent memory allocator (the `link_m' one).
 *.there may be a need for a temporary objects destroyer in addition  to the
 * temporary memory allocator.
 *.some error recorder in addition to the error dumper is in good order.  such
 * recorder would record the error type (this library identification -
 * application side, since such identification is created by the application)
 * and the error details (library error type and details)
 */
typedef struct lxcast_type {
    struct x1f4_track_type link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	void *data, *lock, *side, *text;
    } link_f;
    struct {
	void *driver_fringe, *object_fringe;
    } link_k;
    struct trans_type link_m;
    struct {
	void *fine;
    } link_o;
    struct {
	struct x1f4_datatype_type datatype[2];
    } link_t;
    struct x1f4_frame_type link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} lxcast_type;

typedef struct lxmiss_type {
    union {
	unsigned miss;
	void *data;
    } data;
} lxmiss_type;

typedef struct lxtext_type {
    struct x1f4_nodetype_type nodetype;
    void *text;
} lxtext_type;

typedef struct screen_type {
    struct x1f4_track_type link_e;
    struct {
	const struct x1f4_eelookup_type *eelookup_data;
    } trap_e;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_m;
    struct {
	void *fine;
    } link_o;
    struct {
	unsigned miss;
	const void *data;
    } link_t;
    struct x1f4_frame_type link_v;
    struct {
	int (*free) (void *, void *), (*link) (void *, void **, unsigned),
	    (*mode) (void *, void **, unsigned);
	void *data;
    } link_w;
} screen_type;

#endif				/* __LIBx1f4_lxcast_types_H__ */
