/*
 * lxcast-l.r.c
 * Copyright (C) 2010, 2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcall.h>
#include <lxcast-types.h>

#define I_CAST(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define dxcast(cast) \
    ((struct dxcast_type *) (cast))

int
_libx1f4i0_lxcast_r_logique(void *context, void *output, void **input)
{
    int cast = 0, status = 0, type;
    struct dxcast_type *dxcast_data;
    struct lxcast_type *lxcast_data;
    struct lxtext_type *lxtext_data;
    unsigned i;

    dxcast_data = I_CAST(input[0]);

    lxcast_data = context;

    type = dxcast_data->type;

    lxtext_data = lxcast_data->link_f.text;
    i = ((struct lxmiss_type *) (void *) lxtext_data - 1)->data.miss;
    for (; i; i--) {
	if (lxtext_data->nodetype.code == type) {
	    cast = lxtext_data->nodetype.flags & X1f4_LX_LINK_ACCESS;
	    if (1) {
		break;
	    }
	} else {
	    lxtext_data++;
	}
    }

    l_MODE(cast, output);

    return status;
}
