/*
 * lxcast-e.w.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <af.h>
#include <lxcast-types.h>

#define lxcast(lxcast) \
    ((struct lxcast_type *) (lxcast))

int
x1f4_slip_lxcast(void *subtext, void **data)
{
    int status = 0, type;
    struct dxcast_type *dxcast_data;

    dxcast_data = *data;

    type = dxcast_data->call - 1;

    if (type) {
	dxcast_data->call = type;
    } else {
	type = dxcast_data->type;

	dxcast_data->call = 0;

	if (type < X1f4_E4_CALL) {
	    struct lxtext_type *lxtext_data;
	    unsigned i;

	    lxtext_data = lxcast(subtext)->link_f.text;
	    i = ((struct lxmiss_type *) (void *) lxtext_data - 1)->data.miss;
	    for (; i; i--) {
		if (lxtext_data->nodetype.code == type) {
		    int (*slip) (void *, void **);

		    slip = lxtext_data->nodetype.slip;
		    if (slip) {
			status = slip
			    (lxtext_data->nodetype.context,
			     (void *) &dxcast_data->data);
		    }

		    break;
		} else {
		    lxtext_data++;
		}
	    }
	} else {
	    status = _x1f4_slip_effect(NULL, (void *) &dxcast_data->data);
	}
    }

    return status;
}
