/*
 * lxcast-d.f.c
 * Copyright (C) 2010, 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcall.h>
#include <lxcast-inter.h>
#include <lxcast-types.h>

#define I_CAST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxcast_f_derived(void *context, void *output, void **input)
{
    int status, type;
    struct dxcast_type *dxcast_data;
    struct lxcast_type *lxcast_data;

    dxcast_data = I_CAST(input[0]);

    lxcast_data = context;

    type = dxcast_data->type;
    if (X1f4_E4_CALL < type) {
	struct x1f4_linetext_type *linetext_data;

	linetext_data = I_USER(&dxcast_data->data);
	if (0) {
	} else {
	    const char *name;

	    name = x1f4_c1_empty_string;

	    type = linetext_data->function.type;

#if 0
	    if (1) {
		struct lxtext_type *lxtext_data;
		unsigned i;

		lxtext_data = lxcast_data->link_f.text;
		i = ((struct lxmiss_type *)
		     (void *) lxtext_data - 1)->data.miss;
		for (; i; i--) {
		    if (lxtext_data->nodetype.code == type) {
			name = lxtext_data->nodetype.name;
			if (1) {
			    break;
			}
		    } else {
			lxtext_data++;
		    }
		}

		if (i) {
		} else {
		    if (type == X1f4_E4_VOID) {
			name = "void";
		    } else {
			if (type == lxcast_data->link_i.type) {
			    name = "object";
			}
		    }
		}

		status = 0;

		l_TEXT((char *) name, output);
	    }
#else
	    if (1) {
		struct trans_type trans;

		trans.data = lxcast_data->link_v.data;
		trans.free = lxcast_data->link_v.free;
		trans.link = lxcast_data->link_v.link;
		trans.mode = lxcast_data->link_v.mode;

		status = _libx1f4i0_lxcall_line_type
		    (&name, type, lxcast_data->trap_e.eelookup_data, &trans);
		if (status) {
		    status = _libx1f4i0_lxcast_stat_link(lxcast_data);
		} else {
		    l_TEXT((char *) name, output);
		}
	    }
#endif				/* 0 */
	}
    } else {
	status = _libx1f4i0_lxcast_stat_call(lxcast_data, type);
    }

    return status;
}
