/*
 * lxcast-b...c
 * Copyright (C) 2008-2011, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcast-inter.h>
#include <lxcast-types.h>

#define I_CAST(t)			(*((X1f4_E4_C_USER *) (t)))
#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))

#define l_BILL(e, output) \
    {									      \
	X1f4_E4_C_BILL *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define lxtext(delete)			((struct lxtext_type *) (delete))

int
_libx1f4i0_lxcast___class_b(void *context, void *output, void **input)
{
    int status, type;
    struct dxcast_type *dxcast_data;

    dxcast_data = I_CAST(input[0]);

    type = dxcast_data->type;
    if (type ^ X1f4_E4_BILL) {
	status = _libx1f4i0_lxcast_stat_type
	    (lxtext(context)->text, type, X1f4_E4_BILL);
    } else {
	status = 0;

	l_BILL(I_BILL(&dxcast_data->data), output);
    }

    return status;
}
