/*
 * lxcast-a.k.c
 * Copyright (C) 2010-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <e4.h>
#include <exerrors.h>
#include <lxcast-inter.h>
#include <lxcast-types.h>
#include <nt.h>
#include <retain.h>

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#define I_USER(u)			(*((X1f4_E4_C_USER *) (u)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define lxcast(lxcast) \
    ((struct lxcast_type *) (lxcast))

#define linetext(linetext) \
    ((struct x1f4_linetext_type *) (linetext))

typedef struct fbcast_type {
    int type;
    struct lxcast_type *lxcast_data;
} fbcast_type;

typedef struct upcast_type {
    struct dxcast_type dxcast;
    struct x1f4_nodetype_type *nodetype_data;
} upcast_type;

static int line_driver(void *, void *, void **);
static int line_object(void *, void *, void **);
#if __RETAIN_OBJECT_DATA__
static int pick_object(void *, void *, void **);
#endif				/* __RETAIN_OBJECT_DATA__ */
static int seek_driver(struct lxcast_type *, int,
		       const struct x1f4_linetext_type **);
static int seek_object(struct lxcast_type *, int,
		       const struct x1f4_linetext_type **);
#if __RETAIN_OBJECT_DATA__
static int slip_object(void *);
#endif				/* __RETAIN_OBJECT_DATA__ */

static int
line_driver(void *context, void *output, void **input)
{
    int status;
    struct fbcast_type *fbcast_data;
    struct dxcast_type *object_data;

    object_data = I_USER(input[0]);

    fbcast_data = context;

    if (object_data->type ^ fbcast_data->type) {
	status = _libx1f4i0_lxcast_stat_type
	    (fbcast_data->lxcast_data, object_data->type, fbcast_data->type);
    } else {
	status = 0;

	l_USER(I_USER(&object_data->data), output);
    }

    return status;
}


static int
line_object(void *context, void *output, void **input)
{
    int status;
    struct fbcast_type *fbcast_data;
    struct lxcast_type *lxcast_data;
    void *data;

    fbcast_data = context;

    lxcast_data = fbcast_data->lxcast_data;

    status = lxcast_data->link_v.link
	(lxcast_data->link_v.data, &data, sizeof(struct dxcast_type));
    if (status) {
	status = _libx1f4i0_lxcast_stat_link(lxcast_data);
    } else {
	struct dxcast_type *object_data;

	l_USER(data, output);

	object_data = data;

	object_data->call = 0;
	object_data->type = fbcast_data->type;

	l_USER(I_USER(input[0]), &object_data->data);
    }

    return status;
}


#if __RETAIN_OBJECT_DATA__
static int
pick_object(void *context, void *output, void **input)
{
    int status;
    struct lxcast_type *lxcast_data;
    struct lxtext_type *lxtext_data;
    void *data, **mind;

    lxtext_data = context;

    lxcast_data = lxtext_data->text;

    status = lxcast_data->link_v.pick
	(lxcast_data->link_v.data, &mind, slip_object,
	 sizeof(struct upcast_type), &data);
    if (status) {
	status = _libx1f4i0_lxcast_stat_link(lxcast_data);
    } else {
	struct dxcast_type *object_data;
	struct upcast_type *upcast_data;

	*mind = data;

	upcast_data = data;

	data = &upcast_data->dxcast;

	l_USER(data, output);

	object_data = data;

	object_data->call = 1;
	object_data->type = lxtext_data->nodetype.code;

	l_USER(I_USER(input[0]), &object_data->data);

	if (0) {
	} else {
	    status = lxtext_data->nodetype.lead
		(*((void **) context + 1), lxtext_data->nodetype.context,
		 (void *) &object_data->data);
	    if (status) {
		upcast_data->nodetype_data = NULL;
	    } else {
		upcast_data->nodetype_data = &lxtext_data->nodetype;
	    }
	}
    }

    return status;
}
#endif				/* __RETAIN_OBJECT_DATA__ */


static int
seek_driver(struct lxcast_type *lxcast_data, int outer,
	    const struct x1f4_linetext_type **linetext)
{
    int delete;
    struct fringe_type *fringe_data;

    fringe_data = lxcast_data->link_k.driver_fringe;
    while (fringe_data) {
	if (fringe_data->linetext.function.type == outer) {
	    break;
	}

	fringe_data = fringe_data->fringe_data;
    }

    if (fringe_data) {
	delete = 0;
	*linetext = &fringe_data->linetext;
    } else {
	void *fringe;

	delete = lxcast_data->link_w.link
	    (lxcast_data->link_w.data, &fringe,
	     sizeof(struct fringe_type) + sizeof(struct fbcast_type)
	     + sizeof(int));
	if (delete) {
	} else {
	    struct fbcast_type *fbcast_data;
	    int *args;

	    fringe_data = fringe;

	    fringe_data->fringe_data = lxcast_data->link_k.driver_fringe;
	    lxcast_data->link_k.driver_fringe = fringe_data;

	    *linetext = &fringe_data->linetext;

	    fbcast_data = (void *) (fringe_data + 1);

	    args = (void *) (fbcast_data + 1);

	    *args = X1f4_E4_CASE;

	    fbcast_data->type = outer;
	    fbcast_data->lxcast_data = lxcast_data;

	    fringe_data->linetext.context = fbcast_data;

	    fringe_data->linetext.function.args = args;
	    fringe_data->linetext.function.count = 1;
	    fringe_data->linetext.function.flags =
		X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
	    fringe_data->linetext.function.function = line_driver;
	    fringe_data->linetext.function.length = 12;
	    fringe_data->linetext.function.name = "(object) -> ";
	    fringe_data->linetext.function.type = outer;
	}
    }

    return delete;
}


static int
seek_object(struct lxcast_type *lxcast_data, int inner,
	    const struct x1f4_linetext_type **linetext)
{
    int delete;
    struct fringe_type *fringe_data;

    fringe_data = lxcast_data->link_k.object_fringe;
    while (fringe_data) {
	if ((integral_q) fringe_data->linetext.context == inner) {
	    break;
	}

	fringe_data = fringe_data->fringe_data;
    }

    if (fringe_data) {
	delete = 0;
	*linetext = &fringe_data->linetext;
    } else {
	struct lxtext_type *lxtext_data;
	unsigned i;

	lxtext_data = lxcast_data->link_f.text;
	i = ((struct lxmiss_type *) (void *) lxtext_data - 1)->data.miss;
	for (; i; i--) {
	    if (lxtext_data->nodetype.code == inner) {
		break;
	    } else {
		lxtext_data++;
	    }
	}

	if (i) {
	    if (lxtext_data->nodetype.lead) {
	    } else {
		lxtext_data = NULL;
	    }
	} else {
	    lxtext_data = NULL;
	}

	do {
	    unsigned fbsize;
	    void *fringe;

	    if (lxtext_data) {
#if __RETAIN_OBJECT_DATA__
		fbsize = sizeof(int);
#else
		fbsize = sizeof(struct fbcast_type);
#endif				/* __RETAIN_OBJECT_DATA__ */
	    } else {
		/*
		 * will disallow non retainable types
		 */
		if (X1f4_E4_LAST < inner && inner < X1f4_E4_CALL) {
		    /*
		     * TODO
		     *
		     * a error message detailing the inability should be
		     * introduced here.  Cooperation of e4 required.
		     */
		    delete = 1;
		    if (1) {
			break;
		    }
		} else {
		    fbsize = sizeof(struct fbcast_type);
		}
	    }

	    delete = lxcast_data->link_w.link
		(lxcast_data->link_w.data, &fringe,
		 sizeof(struct fringe_type) + fbsize);
	    if (delete) {
	    } else {
		int *args;

		fringe_data = fringe;

		fringe_data->fringe_data = lxcast_data->link_k.object_fringe;
		lxcast_data->link_k.object_fringe = fringe_data;

		*linetext = &fringe_data->linetext;

#if __RETAIN_OBJECT_DATA__
		if (lxtext_data) {
		    fringe_data->linetext.context = lxtext_data;

		    args = (void *) (fringe_data + 1);

		    *args = inner;
		} else {
#elif 0
		}
#else
		{
#endif				/* __RETAIN_OBJECT_DATA__ */
		    struct fbcast_type *fbcast_data;

		    fbcast_data = (void *) (fringe_data + 1);

		    fringe_data->linetext.context = fbcast_data;

		    fbcast_data->lxcast_data = lxcast_data;
		    fbcast_data->type = inner;

		    args = &fbcast_data->type;
		}

		fringe_data->linetext.function.args = args;
		fringe_data->linetext.function.count = 1;
		fringe_data->linetext.function.flags =
		    X1f4_E4_KEEP_CALL | X1f4_E4_TEXT_LINK;
#if __RETAIN_OBJECT_DATA__
		fringe_data->linetext.function.function =
		    lxtext_data ? pick_object : line_object;
#else
		fringe_data->linetext.function.function = line_object;
#endif				/* __RETAIN_OBJECT_DATA__ */
		fringe_data->linetext.function.length = 12;
		fringe_data->linetext.function.name = "(object) <- ";
		fringe_data->linetext.function.type = X1f4_E4_CASE;
	    }
	} while (0);
    }

    return delete;
}


#if __RETAIN_OBJECT_DATA__
static int
slip_object(void *upcast)
{
    int status;
    struct upcast_type *upcast_data;
    struct x1f4_nodetype_type *nodetype_data;

    upcast_data = upcast;

    nodetype_data = upcast_data->nodetype_data;
    if (nodetype_data) {
	status = nodetype_data->slip
	    (nodetype_data->context, (void *) &upcast_data->dxcast.data);
    } else {
	status = 0;
    }

    return status;
}
#endif				/* __RETAIN_OBJECT_DATA__ */


int
x1f4_lock_lxcast(void *context, int outer, int inner,
		 const struct x1f4_linetext_type **linetext)
{
    int delete = 0;

    if (outer == X1f4_E4_CASE) {
	if (1) {
	    switch (inner) {
	    case X1f4_E4_BILL:
		*linetext = linetext(lxcast(context)->link_f.lock) + 4;
		break;
	    case X1f4_E4_MODE:
		*linetext = linetext(lxcast(context)->link_f.lock) + 5;
		break;
	    case X1f4_E4_REAL:
		*linetext = linetext(lxcast(context)->link_f.lock) + 6;
		break;
	    case X1f4_E4_TEXT:
		*linetext = linetext(lxcast(context)->link_f.lock) + 7;
		break;
	    default:
		delete = seek_object((void *) context, inner, linetext);
	    }
	}
    } else {
	if (inner == X1f4_E4_CASE) {
	    switch (outer) {
	    case X1f4_E4_BILL:
		*linetext = linetext(lxcast(context)->link_f.lock) + 0;
		break;
	    case X1f4_E4_MODE:
		*linetext = linetext(lxcast(context)->link_f.lock) + 1;
		break;
	    case X1f4_E4_REAL:
		*linetext = linetext(lxcast(context)->link_f.lock) + 2;
		break;
	    case X1f4_E4_TEXT:
		*linetext = linetext(lxcast(context)->link_f.lock) + 3;
		break;
	    default:
		delete = seek_driver((void *) context, outer, linetext);
	    }
	} else {
	    delete = 1;
	}
    }

    return delete;
}
