/*
 * lxcast-a.e.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <er.h>
#include <exerrors.h>
#include <lxcast-inter.h>
#include <lxcast-types.h>

#define lxcast(lxcast) \
    ((struct lxcast_type *) (lxcast))

int
_libx1f4i0_lxcast_stat_call(void *lxcast, int type)
{
    LINE_EEER(lxcast(lxcast)->link_e);

    PUSH_DATA("non function pointer type (", 27);
    PUSH_TRAP(type, lxcast(lxcast));
    PUSH_DATA(")", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_free(void *lxcast)
{
    LINE_EEER(lxcast(lxcast)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxcast_stat_lead(void *lxcast, unsigned type)
{
    LINE_EEER(lxcast(lxcast)->link_e);

    PUSH_DATA("will not box non referable, non intrinsic object of type ", 57);
    PUSH_TRAP(type, lxcast(lxcast));

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_link(void *lxcast)
{
    LINE_EEER(lxcast(lxcast)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxcast_stat_null(void *lxcast, const char *name, unsigned size)
{
    LINE_EEER(lxcast(lxcast)->link_e);

    PUSH_DATA("function `", 10);
    PUSH_DATA(name, size);
    PUSH_DATA("' admits no parameters", 22);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_slip(void *lxcast, const char *name, unsigned size,
			    unsigned mask, long mode)
{
    if (mask) {
	_libx1f4i0_lxcast_stat_time(lxcast, name, size, mask, mode);
    } else {
	_libx1f4i0_lxcast_stat_null(lxcast, name, size);
    }

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_time(void *lxcast, const char *name, unsigned size,
			    unsigned mask, long mode)
{
    LINE_EEER(lxcast(lxcast)->link_e);

    PUSH_DATA("out of valid range (-", 21);
    PUSH_BILL(mask);
    PUSH_DATA(" .. ", 4);
    PUSH_BILL(mask - 1);
    PUSH_DATA(") parameter index (", 19);
    PUSH_LONG(mode);
    PUSH_DATA(") for function `", 16);
    PUSH_DATA(name, size);
    PUSH_DATA("'", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcast_stat_type(void *lxcast, int found, int expected)
{
    LINE_EEER(lxcast(lxcast)->link_e);

    PUSH_DATA("mismatched type in conversion from `object' (", 45);
    PUSH_TRAP(found, lxcast(lxcast));
    PUSH_DATA(" found, ", 8);
    PUSH_TRAP(expected, lxcast(lxcast));
    PUSH_DATA(" expected)", 10);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
