/*
 * lxcall-v.o.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <frame.h>
#include <lxcall-inter.h>
#include <lxcast.h>
#include <nt.h>
#include <track.h>

#define I_USER(t)			(*((X1f4_E4_C_USER *) (t)))

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

#define byte(miss)			((unsigned char *) (miss))

typedef struct upcast_type {
    struct x1f4_dxcast_type dxcast;
    union {
	int (*slip) (void *, void **);
    } v;
    void *text;
} upcast_type;

extern const char *const x1f4_c1_empty_string;

static int slip_data(void *);

static int
slip_data(void *upcast)
{
    int (*slip) (void *, void **), status;
    struct upcast_type *upcast_data;

    upcast_data = upcast;

    slip = upcast_data->v.slip;
    if (slip) {
	status = slip
	    (upcast_data->text, (void *) &upcast_data->dxcast.data);
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxcall_post_node(struct x1f4_frame_type *frame_data,
			    struct x1f4_track_type *track_data,
			    struct x1f4_nodetype_type *nodetype_data,
			    const void *data, void *call)
{
    int status;
    void *cast;
    void **mind;

    status = frame_data->pick
	(frame_data->data, &mind, slip_data, sizeof(struct upcast_type),
	 &cast);
    if (status) {
	status = _libx1f4i0_lxcall_stat_link(track_data);
    } else {
	struct upcast_type *upcast_data;
	void *user;

	upcast_data = cast;

	*mind = cast;

	user = I_USER(byte(data) + 8);

	status = nodetype_data->lead(nodetype_data->context, &user);
	if (status) {
	    upcast_data->v.slip = NULL;
	} else {
	    struct x1f4_dxcast_type *dxcast_data;
	    unsigned type;

	    cast = &upcast_data->dxcast;

	    dxcast_data = cast;

	    type = byte(data)[0] << 030 | byte(data)[1] << 020
		| byte(data)[2] << 010 | byte(data)[3];

	    l_USER(cast, call);

	    dxcast_data->call = 1;
	    dxcast_data->type = type;

	    l_USER(user, &dxcast_data->data);

	    upcast_data->v.slip = nodetype_data->slip;
	    upcast_data->text = nodetype_data->context;
	}
    }

    return status;
}
