/*
 * lxcall-v.j.c
 * Copyright (C) 2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <dt.h>
#include <e4.h>
#include <frame.h>
#include <lxcall-inter.h>
#include <track.h>

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

typedef struct upcast_type {
    X1f4_E4_C_USER user;
    int (*slip) (void *, void **);
    void *text;
} upcast_type;

static int slip_node(void *);

static int
slip_node(void *news)
{
    struct upcast_type *upcast_data;

    upcast_data = news;

    return upcast_data->slip(upcast_data->text, &upcast_data->user);
}


int
_libx1f4i0_lxcall_near_node(struct x1f4_frame_type *frame_data,
			    struct x1f4_track_type *track_data,
			    struct x1f4_datatype_type *datatype_data,
			    void *data)
{
    int status;
    void **mind, *news;

    status = frame_data->pick
	(frame_data->data, &mind, slip_node, sizeof(struct upcast_type),
	 &news);
    if (status) {
	status = _libx1f4i0_lxcall_stat_link(track_data);
    } else {
	struct upcast_type *upcast_data;

	*mind = news;

	upcast_data = news;

	upcast_data->slip = datatype_data->slip;
	upcast_data->text = datatype_data->context;

	upcast_data->user = data;
    }

    return status;
}
