/*
 * lxcall-v.i.c
 * Copyright (C) 2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <exerrors.h>
#include <frame.h>
#include <lxcall-inter.h>
#include <nt.h>
#include <track.h>

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

typedef struct upcast_type {
    X1f4_E4_C_USER user;
    int (*slip) (void *, void **);
    void *text;
} upcast_type;

static int slip_node(void *);

static int
slip_node(void *news)
{
    int (*slip) (void *, void **), status;
    struct upcast_type *upcast_data;

    upcast_data = news;

    slip = upcast_data->slip;
    if (slip) {
	status = slip(upcast_data->text, &upcast_data->user);
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxcall_pick_node(struct x1f4_frame_type *frame_data,
			    struct x1f4_track_type *track_data,
			    struct x1f4_nodetype_type *nodetype_data,
			    void *data, void *call)
{
    int status;
    void **mind, *news;

    status = frame_data->pick
	(frame_data->data, &mind, slip_node, sizeof(struct upcast_type),
	 &news);
    if (status) {
	status = _libx1f4i0_lxcall_stat_link(track_data);
    } else {
	struct upcast_type *upcast_data;

	*mind = news;

	upcast_data = news;

	status = nodetype_data->lead(nodetype_data->context, &data);
	if (status) {
	    upcast_data->slip = NULL;
	} else {
	    upcast_data->slip = nodetype_data->slip;
	    upcast_data->text = nodetype_data->context;

	    upcast_data->user = data;

	    l_USER(data, call);
	}
    }

    return status;
}
