/*
 * lxcall-t.u.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <frame.h>
#include <lxcall-inter.h>
#include <lxcast.h>
#include <track.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (X1f4_E4_C_TEXT *) (output);				      \
	*l = (e);							      \
    }

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

int
_libx1f4i0_lxcall_push_text(struct x1f4_frame_type *frame_data,
			    struct x1f4_track_type *track_data, void *data,
			    void *call)
{
    int status;
    unsigned size;
    void *mind, *text;

    text = I_TEXT(data);

    size = strlen(text);

    size++;

    status = frame_data->link
	(frame_data->data, &mind, sizeof(struct x1f4_dxcast_type) + size);
    if (status) {
	status = _libx1f4i0_lxcall_stat_link(track_data);
    } else {
	struct x1f4_dxcast_type *dxcast_data;

	dxcast_data = mind;

	l_USER(mind, call);

	mind = dxcast_data + 1;

	dxcast_data->call = 0;
	dxcast_data->type = X1f4_E4_TEXT;

	l_TEXT(mind, &dxcast_data->data);

	memcpy(mind, text, size);
    }

    return status;
}
