/*
 * lxcall-t.o.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <exerrors.h>
#include <frame.h>
#include <lxcall-inter.h>
#include <lxcast.h>
#include <track.h>
#include <trans.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

typedef struct upcast_type {
    struct x1f4_dxcast_type dxcast;
    union {
	int (*free) (void *, void *);
    } v;
    void *text;
} upcast_type;

extern const char *const x1f4_c1_empty_string;

static int slip_text(void *);

static int
slip_text(void *upcast)
{
    int status;
    struct upcast_type *upcast_data;
    void *text;

    upcast_data = upcast;

    text = I_TEXT(&upcast_data->dxcast.data);
    if (text != x1f4_c1_empty_string) {
	status = upcast_data->v.free(upcast_data->text, text);
	if (status) {
	    status = X1f4_EX_CRITICAL;
	}
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxcall_post_text(struct x1f4_frame_type *frame_data,
			    struct x1f4_trans_type *trans_data, 
			    struct x1f4_track_type *track_data, void *data,
			    void *call)
{
    int status;
    void *cast;
    void **mind;

    status = frame_data->pick
	(frame_data->data, &mind, slip_text, sizeof(struct upcast_type),
	 &cast);
    if (status) {
	status = _libx1f4i0_lxcall_stat_link(track_data);
    } else {
	struct upcast_type *upcast_data;

	upcast_data = cast;

	*mind = cast;

	if (0) {
	} else {
	    struct x1f4_dxcast_type *dxcast_data;

	    cast = &upcast_data->dxcast;

	    dxcast_data = cast;

	    l_TEXT(cast, call);

	    dxcast_data->call = 1;
	    dxcast_data->type = X1f4_E4_TEXT;

	    l_TEXT(I_TEXT(data), &dxcast_data->data);

	    upcast_data->v.free = trans_data->free;
	    upcast_data->text = trans_data->data;
	}
    }

    return status;
}
