/*
 * lxcall-t.k.c
 * Copyright (C) 2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>
#include <string.h>

#include <e4.h>
#include <exerrors.h>
#include <frame.h>
#include <lxcall-inter.h>
#include <track.h>
#include <trans.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (X1f4_E4_C_TEXT *) (output);				      \
	*l = (e);							      \
    }

typedef struct upcast_type {
    X1f4_E4_C_TEXT text;
    int (*free) (void *, void *);
    void *data;
} upcast_type;

extern const char *const x1f4_c1_empty_string;

static int slip_text(void *);

static int
slip_text(void *news)
{
    int status;
    struct upcast_type *upcast_data;

    upcast_data = news;
    if (upcast_data->free) {
	status = upcast_data->free(upcast_data->data, upcast_data->text);
	if (status) {
	    status = X1f4_EX_CRITICAL;
	}
    } else {
	status = 0;
    }

    return status;
}


int
_libx1f4i0_lxcall_line_text(struct x1f4_frame_type *frame_data,
			    struct x1f4_trans_type *trans_data, 
			    struct x1f4_track_type *track_data, void *call)
{
    X1f4_E4_C_TEXT text;
    int status;
    unsigned size;

    text = I_TEXT(call);

    size = strlen(text);

    if (size) {
	void **mind, *news;

	status = frame_data->pick
	    (frame_data->data, &mind, slip_text, sizeof(struct upcast_type),
	     &news);
	if (status) {
	    status = _libx1f4i0_lxcall_stat_link(track_data);
	} else {
	    struct upcast_type *upcast_data;
	    void *data;

	    *mind = news;

	    upcast_data = news;

	    size++;

	    status = trans_data->link(trans_data->data, &data, size);
	    if (status) {
		status = _libx1f4i0_lxcall_stat_link(track_data);

		upcast_data->free = NULL;
	    } else {
		upcast_data->data = trans_data->data;
		upcast_data->free = trans_data->free;

		upcast_data->text = text;

		l_TEXT(data, call);

		memcpy(data, text, size);
	    }
	}
    } else {
	status = 0;

	l_TEXT((char *const) x1f4_c1_empty_string, call);
    }

    return status;
}
