/*
 * lxcall-t.i.c
 * Copyright (C) 2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <exerrors.h>
#include <frame.h>
#include <lxcall-inter.h>
#include <track.h>
#include <trans.h>

#define I_TEXT(t)			(*((X1f4_E4_C_TEXT *) (t)))

typedef struct upcast_type {
    X1f4_E4_C_TEXT text;
    int (*free) (void *, void *);
    void *data;
} upcast_type;

extern const char *const x1f4_c1_empty_string;

static int slip_text(void *);

static int
slip_text(void *news)
{
    int status;
    struct upcast_type *upcast_data;

    upcast_data = news;
    status = upcast_data->free(upcast_data->data, upcast_data->text);
    if (status) {
	status = X1f4_EX_CRITICAL;
    }

    return status;
}


int
_libx1f4i0_lxcall_pick_text(struct x1f4_frame_type *frame_data,
			    struct x1f4_trans_type *trans_data, 
			    struct x1f4_track_type *track_data, void *data)
{
    X1f4_E4_C_TEXT text;
    int status;

    text = I_TEXT(data);

    if (text == x1f4_c1_empty_string) {
	status = 0;
    } else {
	void **mind, *news;

	status = frame_data->pick
	    (frame_data->data, &mind, slip_text, sizeof(struct upcast_type),
	     &news);
	if (status) {
	    status = _libx1f4i0_lxcall_stat_link(track_data);
	} else {
	    struct upcast_type *upcast_data;

	    *mind = news;

	    upcast_data = news;

	    upcast_data->data = trans_data->data;
	    upcast_data->free = trans_data->free;

	    upcast_data->text = text;
	}
    }

    return status;
}
