/*
 * lxcall-t.a.c
 * Copyright (C) 2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <frame.h>
#include <lxcall-inter.h>
#include <track.h>

#define l_TEXT(e, output) \
    {									      \
	X1f4_E4_C_TEXT *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

extern const char *const x1f4_c1_empty_string;

int
_libx1f4i0_lxcall_part_text(struct x1f4_frame_type *frame_data, 
			    struct x1f4_track_type *track_data, void *data,
			    unsigned size, void *call)
{
    int status;
    void *mind;

    if (size) {
	size++;

	status = frame_data->link(frame_data->data, &mind, size);
	if (status) {
	    status = _libx1f4i0_lxcall_stat_link(track_data);
	} else {
	    l_TEXT(mind, call);

	    memcpy(mind, data, size);
	}
    } else {
	status = 0;

	l_TEXT((char *const) x1f4_c1_empty_string, call);
    }

    return status;
}
