/*
 * lxcall-inter.h
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LIBx1f4_lxcall_inter_H__
#define __LIBx1f4_lxcall_inter_H__

#include <ct.h>
#include <e4.h>
#include <it.h>
#include <track.h>
#include <trans.h>

extern int _libx1f4i0_lxcall_even_list
    (const struct x1f4_function_type *, const struct x1f4_function_type *,
     unsigned, void ***, struct x1f4_trans_type *, struct x1f4_iturn_type *,
     struct x1f4_cturn_type *, struct x1f4_track_type *,
     const struct x1f4_eelookup_type *);
extern int _libx1f4i0_lxcall_lock_call
    (const struct x1f4_function_type *, unsigned, struct x1f4_trans_type *,
     struct x1f4_track_type *, struct x1f4_linetext_type **);
extern int _libx1f4i0_lxcall_pick_call
    (void **, const struct x1f4_function_type *, unsigned,
     struct x1f4_trans_type *, struct x1f4_track_type *,
     struct x1f4_linetext_type **);
extern int _libx1f4i0_lxcall_slip_call
    (void **, const struct x1f4_function_type *, unsigned,
     struct x1f4_linetext_type **, struct x1f4_linetext_type *, void **);
extern int _libx1f4i0_lxcall_stat_fink
    (struct x1f4_track_type *, int, const struct x1f4_function_type *);
extern int _libx1f4i0_lxcall_stat_link(struct x1f4_track_type *);
extern int _libx1f4i0_lxcall_stat_list
    (struct x1f4_track_type *, unsigned, unsigned,
     const struct x1f4_function_type *);
extern int _libx1f4i0_lxcall_stat_lock
    (struct x1f4_track_type *, const struct x1f4_eelookup_type *, int, int,
     int, const struct x1f4_function_type *);

#endif				/* __LIBx1f4_lxcall_inter_H__ */
