/*
 * lxcall-e.r.c
 * Copyright (C) 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <e4.h>
#include <lxcall-types.h>

int
_libx1f4i0_lxcall_line_side(void *data, void *tile,
			    const struct x1f4_operator_type *operator_line,
			    const char *const *side_f, unsigned slip)
{
    const char *const *names;
    struct tide_type *tide_data;
    struct x1f4_operator_type **operator;
    unsigned i;

    tide_data = data;
    tide_data -= slip;

    operator = data;

    names = side_f;

    i = slip;
    for (; i; i--) {
	const char *name, *side;
	struct x1f4_linetext_type *linetext_data;

	side = *names++;
	linetext_data = tile;
	name = linetext_data->function.name;
	while (name) {
	    if (name == side) {
		break;
	    } else {
		linetext_data++;
		name = linetext_data->function.name;
	    }
	}
	if (name) {
	    *operator = &tide_data->operator;

	    tide_data->operator = *operator_line++;
	    tide_data->operator.args = linetext_data->function.args;
	    tide_data->operator.type = linetext_data->function.type;
	    tide_data->operator.extension2 = &tide_data->tidespan;
	    tide_data->tidespan.bits = X1f4_E4_CALL_LINK;
	    tide_data->tidespan.line = linetext_data;

	    tide_data++;

	    operator++;
	}
    }

    *operator = NULL;

    return 0;
}
