/*
 * lxcall-e.q.c
 * Copyright (C) 2011-2012, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <e42.h>
#include <trans.h>

#define PICK_SIZE			80

typedef struct call_type {
    struct trans_type *trans_data;
    unsigned line, size;
    void *data;
} call_type;

static int line_type(void *, const char *, unsigned);

static int
line_type(void *call, const char *text, unsigned pick)
{
    int status = 0;

    do {
	char *data;
	struct call_type *call_data;
	unsigned line, size;

	call_data = call;

	data = call_data->data;

	line = call_data->line;
	size = call_data->size;

	if (size - line < pick) {
	    struct trans_type *trans_data;

	    do {
		size <<= 1;
	    } while (size - line < pick);

	    trans_data = call_data->trans_data;

	    status = trans_data->mode
		(trans_data->data, &call_data->data, size + 1);
	    if (status) {
		break;
	    }

	    call_data->size = size;

	    data = call_data->data;
	}

	call_data->line = line + pick;

	memcpy(data + line, text, pick);
    } while (0);

    return status;
}


int
_libx1f4i0_lxcall_line_type(const char **name, int type,
			    const struct x1f4_eelookup_type *eelookup_data,
			    struct trans_type *trans_data)
{
    int status;
    struct call_type call;

    status = trans_data->link(trans_data->data, &call.data, PICK_SIZE + 1);
    if (status) {
    } else {
	call.line = 0;
	call.size = PICK_SIZE;
	call.trans_data = trans_data;

	status = x1f4_dump_type(&call, line_type, type, eelookup_data);
	if (status) {
	    trans_data->free(trans_data->data, call.data);
	} else {
	    char *data;

	    data = call.data;
	    if (*data == '`') {
		call.line -= 2;
		data++;
	    }

	    data[call.line] = 0;

	    *name = data;
	}
    }

    return status;
}
