/*
 * lxcall-e.o.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>

int
_libx1f4i0_lxcall_slip_call(void **input, void *side, unsigned offset,
			    struct x1f4_linetext_type **linetext,
			    struct x1f4_linetext_type *linetext_slip,
			    void **subtext)
{
    int *args, status;
    struct x1f4_function_type *function_data;
    struct x1f4_linetext_type *linetext_data;
    unsigned count, flags;
    void *near;

    function_data = side;

    linetext_data = *linetext;

    count = function_data->count - offset;

    flags = linetext_data->function.flags;

    do {
	if (flags & (X1f4_E4_LINK_PASS | X1f4_E4_POST_TYPE)) {
	    flags |= X1f4_E4_POST_TYPE;
	} else {
	    if (linetext_data->function.count) {
	    } else {
		args = (void *) (function_data->args + offset);
		if (1) {
		    break;
		}
	    }
	}

	{
	    int *line;
	    const int *plot, *text;
	    unsigned class, i, scale;

	    args = (void *) (linetext_slip + 1);
	    line = args;
	    plot = linetext_data->function.args;
	    class = linetext_data->function.count;
	    scale = count - class;
	    text = function_data->args + offset + class;
	    i = class;
	    for (; i; i--) {
		int slip;

		slip = *plot++;
		*line++ = slip == X1f4_E4_SLIP ? *(text - i) : slip;
	    }
	    memcpy(line, text, scale * sizeof(int));
	    if (flags & X1f4_E4_POST_TYPE) {
		line += scale;
		memcpy(line, plot, class * sizeof(int));
		line += class;
		memcpy(line, text + count + offset, scale * sizeof(int));
	    }
	}
    } while (0);

    *linetext_slip = *linetext_data;

    linetext_slip->function.args = args;
    linetext_slip->function.count = count;
    linetext_slip->function.flags =
	flags & ~(X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST);

    near = ((void **) input[-1])[X1f4_E4_USED_META];

    status = linetext_data->function.function
	((void *) linetext_data->context, linetext_slip, &near);
    if (status) {
    } else {
	*subtext = near;
	*linetext = linetext_slip;
    }

    return status;
}
