/*
 * lxcall-e.k.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <e4.h>
#include <lxcall-inter.h>
#include <track.h>
#include <trans.h>

int
_libx1f4i0_lxcall_lock_call(const struct x1f4_function_type *function_data,
			    unsigned offset,
			    struct x1f4_trans_type *trans_data,
			    struct x1f4_track_type *track_data,
			    struct x1f4_linetext_type **linetext)
{
    int status;
    struct x1f4_linetext_type *linetext_data;
    unsigned count, flags, white = 0;
    void *miss;

    linetext_data = *linetext;

    count = function_data->count - offset;

    flags = linetext_data->function.flags;

    /*
     * the -args- arrays needs to be always copied, as the original may be
     * destroyed (it will be if created by another program)
     */

    white += count * sizeof(int);

    if (flags & (X1f4_E4_LINK_PASS | X1f4_E4_POST_TYPE)) {
	flags |= X1f4_E4_POST_TYPE;
	white <<= 1;
    } else {
    }

    status = trans_data->link
	(trans_data->data, &miss, sizeof(struct x1f4_linetext_type) + white);
    if (status) {
	status = _libx1f4i0_lxcall_stat_link(track_data);
    } else {
	int *args;
	struct x1f4_linetext_type *linetext_slip;

	linetext_slip = miss;

	*linetext = linetext_slip;

	*linetext_slip = *linetext_data;

	if (white) {
	    int *line;
	    const int *plot, *text;
	    unsigned class, i, scale;

	    args = (void *) (linetext_slip + 1);
	    line = args;
	    plot = linetext_slip->function.args;
	    class = linetext_slip->function.count;
	    scale = count - class;
	    text = function_data->args + offset + class;
	    i = class;
	    for (; i; i--) {
		int slip;

		slip = *plot++;
		*line++ = slip == X1f4_E4_SLIP ? *(text - i) : slip;
	    }
	    memcpy(line, text, scale * sizeof(int));
	    if (flags & X1f4_E4_POST_TYPE) {
		line += scale;
		memcpy(line, plot, class * sizeof(int));
		line += class;
		memcpy(line, text + count + offset, scale * sizeof(int));
	    }
	} else {
	    args = NULL;
	}

	linetext_slip->function.args = args;
	linetext_slip->function.count = count;
	linetext_slip->function.flags = flags;
    }

    return status;
}
