/*
 * lxcall-e.i.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <lxcall-inter.h>
#include <track.h>
#include <trans.h>

int
_libx1f4i0_lxcall_pick_call(void **input,
			    const struct x1f4_function_type *function_data,
			    unsigned offset,
			    struct x1f4_trans_type *trans_data,
			    struct x1f4_track_type *track_data,
			    struct x1f4_linetext_type **linetext)
{
    int status;
    struct x1f4_linetext_type *linetext_data;

    linetext_data = *linetext;

    status = _libx1f4i0_lxcall_lock_call
	(function_data, offset, trans_data, track_data, &linetext_data);
    if (status) {
    } else {
	void *near;

	linetext_data->function.flags &=
	    ~(X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST);

	near = ((void **) input[-1])[X1f4_E4_USED_META];

	status = linetext_data->function.function
	    ((void *) linetext_data->context, linetext_data, &near);
	if (status) {
	} else {
	    *linetext = linetext_data;

	    linetext_data->context = near;
	}
    }

    return status;
}
