/*
 * lxcall-e.g.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <string.h>

#include <copy.h>
#include <ct.h>
#include <e4.h>
#include <exerrors.h>
#include <fd.h>
#include <it.h>
#include <lxcall-inter.h>
#include <lxcast.h>
#include <lxtrap-inter.h>
#include <lxtrap-types.h>
#include <track.h>
#include <trans.h>

#define I_BILL(t)			(*((X1f4_E4_C_BILL *) (t)))
#define I_MODE(t)			(*((X1f4_E4_C_MODE *) (t)))
#define I_REAL(t)			(*((X1f4_E4_C_REAL *) (t)))

#define l_BILL(e, output) \
    {									      \
	X1f4_E4_C_BILL *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define l_MODE(e, output) \
    {									      \
	X1f4_E4_C_MODE *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define l_REAL(e, output) \
    {									      \
	X1f4_E4_C_REAL *l;						      \
									      \
	l = (output);							      \
	*l = (e);							      \
    }

#define SCALAR_BITS \
    ((1 << X1f4_E4_BILL) | (1 << X1f4_E4_MODE) | (1 << X1f4_E4_REAL))

static int rule_line(const struct x1f4_function_type *, unsigned,
		     unsigned, const struct x1f4_function_type *, unsigned,
		     unsigned, unsigned, struct x1f4_iturn_type *,
		     struct x1f4_cturn_type *, void **);
static int type_name(int, int, void *, void *);

static int
rule_line(const struct x1f4_function_type *function_text,
	  unsigned o, unsigned post,
	  const struct x1f4_function_type *function_data, unsigned offset,
	  unsigned h, unsigned mind, struct x1f4_iturn_type *iturn_data,
	  struct x1f4_cturn_type *cturn_data, void **track)
{
    const int *data;
    int delete, status = 0;
    const int *text;
    struct fxdata_type *missed_data;
    struct x1f4_dxcast_type *dxcast_slip;

    data = function_data->args + offset;
    text = function_text->args;

    missed_data = (void *) (track + h);
    missed_data++;

    dxcast_slip = (void *) (missed_data + h);

    h += offset;

    delete = o;
    for (; delete; delete--, track++) {
	int name, type;

	name = *data;
	type = *text;
	if (type == X1f4_E4_SLIP) {
	    type = name;
	}

	if (name ^ type) {
	    do {
		if ((type | name) & ~15) {
		} else {
		    if ((1 << type) & SCALAR_BITS
			&& (1 << name) & SCALAR_BITS) {
			type_name(type, name, *track, missed_data);
			*track = missed_data;
			missed_data++;
			break;
		    }
		}

		if (name == X1f4_E4_CASE) {
		    int fold;
		    struct x1f4_dxcast_type *dxcast_data;

		    dxcast_data = *(void **) *track;
		    fold = dxcast_data->type;
		    if (fold ^ type) {
			if ((type | fold) & ~15) {
			} else {
			    if ((1 << type) & SCALAR_BITS
				&& (1 << fold) & SCALAR_BITS) {
				type_name(type, fold, &dxcast_data->data,
					  missed_data);
				*track = missed_data;
				missed_data++;
				break;
			    }
			}
		    } else {
			copy_miss(missed_data, name, &dxcast_data->data);
			*track = missed_data;
			missed_data++;
			break;
		    }
		} else {
		    if (type == X1f4_E4_CASE) {
			*(void **) missed_data = dxcast_slip;
			copy_miss(&dxcast_slip->data, name, *track);
			dxcast_slip++->type = name;
			*track = missed_data;
			missed_data++;
			break;
		    }
		}

#if 0
		if (iturn_data->link) {
		    const struct x1f4_operator_type *operator_data;

		    status = iturn_data->link
			(iturn_data->text, type, name, &operator_data);
		    if (status) {
		    } else {
			status = operator_data->operator(missed_data, track);
			if (status) {
			    break;
			} else {
			    *track = missed_data;
			    missed_data++;
			    break;
			}
		    }
		}
#endif				/* 0 */

#if 0
		if (cturn_data->link) {
		    const struct x1f4_linetext_type *linetext_data;

		    status = cturn_data->link
			(cturn_data->text, type, name, &linetext_data);
		    if (status) {
		    } else {
			status = linetext_data->function.function
			    ((void *) linetext_data->context, missed_data,
			     track);
			if (status) {
			    break;
			} else {
			    *track = missed_data;
			    missed_data++;
			    break;
			}
		    }
		}
#endif				/* 0 */

		status = X1f4_EX_CANNOT_CONTINUE;
	    } while (0);
	    if (status) {
		break;
	    }
	} else {
	    if (type == X1f4_E4_CASE) {
		*(void **) missed_data = dxcast_slip;
		*dxcast_slip++ =
		    *(struct x1f4_dxcast_type *) *(void **) *track;
		*track = missed_data;
		missed_data++;
	    } else {
		copy_miss(missed_data, name, *track);
		*track = missed_data;
		missed_data++;
	    }
	}

	data++;
	text++;
    }
    if (delete) {
    } else {
	delete = h - o - offset;
	for (; delete; delete--, track++) {
	    int type;

	    type = *data++;
	    if (type == X1f4_E4_CASE) {
		*(void **) missed_data = dxcast_slip;
		*dxcast_slip++ =
		    *(struct x1f4_dxcast_type *) *(void **) *track;
		*track = missed_data;
		missed_data++;
	    } else {
		copy_miss(missed_data, type, *track);
		*track = missed_data;
		missed_data++;
	    }
	}
    }

    return status;
}


static int
type_name(int type, int name, void *lead, void *seek)
{
    switch (type) {
    case X1f4_E4_BILL:
	if (name == X1f4_E4_MODE) {
	    l_BILL(I_MODE(lead), seek);
	} else {
	    l_BILL(I_REAL(lead), seek);
	}
	break;
    case X1f4_E4_MODE:
	if (name == X1f4_E4_BILL) {
	    l_MODE(I_BILL(lead), seek);
	} else {
	    l_MODE(I_REAL(lead), seek);
	}
	break;
    default:
	if (name == X1f4_E4_BILL) {
	    l_REAL(I_BILL(lead), seek);
	} else {
	    l_REAL(I_MODE(lead), seek);
	}
    }

    return 0;
}


int
_libx1f4i0_lxcall_rule_list(const struct x1f4_function_type *function_text,
			    const struct x1f4_function_type *function_data,
			    unsigned offset, unsigned record, void ***input,
			    struct x1f4_trans_type *trans_data,
			    struct x1f4_iturn_type *iturn_data,
			    struct x1f4_cturn_type *cturn_data,
			    struct x1f4_track_type *track_data,
			    const struct x1f4_eelookup_type *eelookup_data)
{
    int delete, status = 0;
    unsigned h, o, x = 0;

    h = function_data->count;
    o = function_text->count;

    delete = h - o - offset;
    if (delete && !(0 < delete && function_text->flags & X1f4_E4_SIDE_LIST)) {
	status = _libx1f4i0_lxcall_stat_list
	    (track_data, h - offset, o, function_text);
    } else {
	unsigned flat = 0, mind, post;
	const int *data, *text;

	data = function_data->args + offset;
	text = function_text->args;

	mind = function_data->flags & X1f4_E4_POST_TYPE;
	post = function_text->flags & X1f4_E4_POST_TYPE;

	delete = o;
	for (; delete; delete--) {
	    int name, type;

	    name = *data;
	    type = *text;
	    if (type == X1f4_E4_SLIP) {
		type = name;
	    }

	    if (name ^ type) {
		do {
		    if ((type | name) & ~15) {
		    } else {
			if ((1 << type) & SCALAR_BITS
			    && (1 << name) & SCALAR_BITS) {
			    type = name;
			    flat++;
			    break;
			}
		    }

		    if (name == X1f4_E4_CASE) {
			int fold;
			struct x1f4_dxcast_type *dxcast_data;

			dxcast_data = *(void **) *(*input + o - delete);
			fold = dxcast_data->type;
			if (fold ^ type) {
			    if ((type | fold) & ~15) {
			    } else {
				if ((1 << type) & SCALAR_BITS
				    && (1 << fold) & SCALAR_BITS) {
				    type = name;
				    flat++;
				    break;
				}
			    }
			} else {
			    type = name;
			    flat++;
			    break;
			}
		    } else {
			if (type == X1f4_E4_CASE) {
			    type = name;
			    flat++;
			    x++;
			    break;
			}
		    }

#if 0
		    if (iturn_data->link) {
			const struct x1f4_operator_type *operator_data;

			if (iturn_data->link
			    (iturn_data->text, type, name, &operator_data)) {
			} else {
			    type = name;
			    flat++;
			    break;
			}
		    }
#endif				/* 0 */

#if 0
		    if (cturn_data->link) {
			const struct x1f4_linetext_type *linetext_data;

			if (cturn_data->link
			    (cturn_data->text, type, name, &linetext_data)) {
			} else {
			    type = name;
			    flat++;
			    break;
			}
		    }
#endif				/* 0 */

		    status = _libx1f4i0_lxcall_stat_lock
			(track_data, eelookup_data, name, type,
			 text - function_text->args, function_text);
		} while (0);
		if (name ^ type) {
		    if (1) {
			break;
		    }
		}

		if (post) {
		    if (text[o] & X1f4_E4_POST_XSET) {
			/*
			 * can convert the types, but not the reference...
			 * display a better descriptive message?
			 */
			status = _libx1f4i0_lxcall_stat_fink
			    (track_data, text - function_text->args,
			     function_text);
			if (1) {
			    break;
			}
		    }
		}
	    } else {
		if (post) {
		    if (mind) {
			unsigned pass;

			pass = text[o];
			if ((data[h] ^ pass) & X1f4_E4_POST_XSET) {
			    if (pass & X1f4_E4_POST_XSET) {
				status = _libx1f4i0_lxcall_stat_fink
				    (track_data, text - function_text->args,
				     function_text);
				if (1) {
				    break;
				}
			    } else {
				flat++;
			    }
			}
		    } else {
			if (text[o] & X1f4_E4_POST_XSET) {
			    status = _libx1f4i0_lxcall_stat_fink
				(track_data, text - function_text->args,
				 function_text);
			    if (1) {
				break;
			    }
			}
		    }
		} else {
		    if (mind) {
			if (data[h] & X1f4_E4_POST_XSET) {
			    flat++;
			}
		    }
		}

		if (type == X1f4_E4_CASE) {
		    x++;
		}
	    }

	    data++;
	    text++;
	}
	if (delete) {
	} else {
	    flat = h - offset;

	    delete = h - o - offset;
	    for (; delete; delete--) {
		if (*data == X1f4_E4_CASE) {
		    x++;
		}

		data++;
	    }

	    if (1) {
		void *line;

		h -= offset;

		status = trans_data->link
		    (trans_data->data, &line,
		     sizeof(void *) * (h + record)
		     + (flat + 1) * sizeof(struct fxdata_type)
		     + x * sizeof(struct x1f4_dxcast_type));
		if (status) {
		    status = _libx1f4i0_lxcall_stat_link(track_data);
		} else {
		    void **track;

		    track = line;
		    track += record;

		    memcpy(track, *input, sizeof(void *) * h);

		    *input = track;

		    status = rule_line
			(function_text, o, post, function_data, offset,
			 h, mind, iturn_data, cturn_data, track);
		}
	    }
	}
    }

    return status;
}
