/*
 * lxcall-a.e.c
 * Copyright (C) 2008-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <e4.h>
#include <er.h>
#include <exerrors.h>
#include <track.h>

int
_libx1f4i0_lxcall_stat_fink(struct x1f4_track_type *track_data, int rank,
			    const struct x1f4_function_type *function_data)
{
    LINE_EEER(*track_data);

    PUSH_DATA("unmatched reference class for `", 31);
    PUSH_DATA(function_data->name, function_data->length);
    PUSH_DATA("' ", 2);
    PUSH_MODE(rank + 1);
    PUSH_RANK(rank);
    PUSH_DATA(" argument", 9);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcall_stat_link(struct x1f4_track_type *track_data)
{
    LINE_EEER(*track_data);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxcall_stat_list(struct x1f4_track_type *track_data, unsigned found,
			    unsigned expected,
			    const struct x1f4_function_type *function_data)
{
    LINE_EEER(*track_data);

    PUSH_DATA("wrong number of arguments (", 27);
    PUSH_BILL(found);
    PUSH_DATA(" found, ", 8);
    PUSH_BILL(expected);
    PUSH_DATA(" expected) for `", 16);
    PUSH_DATA(function_data->name, function_data->length);
    PUSH_DATA("'", 1);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}


int
_libx1f4i0_lxcall_stat_lock(struct x1f4_track_type *track_data,
			    const struct x1f4_eelookup_type *eelookup_data,
			    int found, int expected, int rank,
			    const struct x1f4_function_type *function_data)
{
    LINE_EEER(*track_data);

    PUSH_DATA("mismatched type (", 17);
    PUSH_TYPE(found, eelookup_data);
    PUSH_DATA(" found, ", 8);
    PUSH_TYPE(expected, eelookup_data);
    PUSH_DATA(" expected) for `", 16);
    PUSH_DATA(function_data->name, function_data->length);
    PUSH_DATA("' ", 2);
    PUSH_MODE(rank + 1);
    PUSH_RANK(rank);
    PUSH_DATA(" argument", 9);

    POST_EEER();

    return X1f4_EX_CAN_CONTINUE;
}
