/*
 * lxcall-a.8.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ct.h>
#include <e4.h>
#include <it.h>
#include <lxcall-inter.h>
#include <lxcast.h>
#include <track.h>
#include <trans.h>

#define l_USER(e, output) \
    {									      \
	X1f4_E4_C_USER *l;						      \
									      \
	l = (void *) (output);						      \
	*l = (e);							      \
    }

extern const void *const x1f4_a1_walk_link;

static int miss_call(void *, int, void *, struct x1f4_dispatch_type **);
static int pick_call(void *, void **, void **,
		     const struct x1f4_function_type *, unsigned,
		     struct x1f4_trans_type *, struct x1f4_track_type *,
		     struct x1f4_linetext_type *);
static int slip_call(void *, void **, void **,
		     const struct x1f4_function_type *, unsigned,
		     struct x1f4_trans_type *, struct x1f4_track_type *,
		     struct x1f4_linetext_type *);

static int
miss_call(void *text, int success, void *output,
	  struct x1f4_dispatch_type **dispatch)
{
    *dispatch = NULL;

    return success;
}


static int
pick_call(void *output, void **input, void **track,
	  const struct x1f4_function_type *function_data, unsigned offset,
	  struct x1f4_trans_type *trans_data,
	  struct x1f4_track_type *track_data,
	  struct x1f4_linetext_type *linetext_data)
{
    int status;

    do {
	int type;
	void *deftext;

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    status = _libx1f4i0_lxcall_pick_call
		(input, function_data, offset, trans_data, track_data,
		 &linetext_data);
	    if (status) {
		break;
	    }
	}

	deftext = (void *) linetext_data->context;

	type = linetext_data->function.type;

	if (type == X1f4_E4_CASE) {
	} else {
	    void *miss;

	    status = trans_data->link
		(trans_data->data, &miss, sizeof(struct x1f4_dxcast_type));
	    if (status) {
		status = _libx1f4i0_lxcall_stat_link(track_data);
		break;
	    } else {
		struct x1f4_dxcast_type *dxcast_data;

		dxcast_data = miss;

		l_USER(miss, output);

		dxcast_data->call = 0;
		dxcast_data->type = type;

		output = &dxcast_data->data;
	    }
	}

	status = linetext_data->function.function(deftext, output, track);
    } while (0);

    return status;
}


static int
slip_call(void *output, void **input, void **track,
	  const struct x1f4_function_type *function_data, unsigned offset,
	  struct x1f4_trans_type *trans_data,
	  struct x1f4_track_type *track_data,
	  struct x1f4_linetext_type *linetext_data)
{
    int status;

    do {
	int type;
	unsigned cast, mind;
	void *miss;

	type = linetext_data->function.type;

	if (type == X1f4_E4_CASE) {
	    cast = 0;
	} else {
	    cast = sizeof(struct x1f4_dxcast_type);
	}

	if (linetext_data->function.flags
	    & (X1f4_E4_SIDE_LIST | X1f4_E4_SLIP_LIST)) {
	    mind = sizeof(struct x1f4_linetext_type);
	    if (linetext_data->function.flags
		& (X1f4_E4_LINK_PASS | X1f4_E4_POST_TYPE)) {
		mind += (function_data->count - offset) * sizeof(int) << 1;
	    } else {
		if (linetext_data->function.count) {
		    mind += sizeof(int) * (function_data->count - offset);
		}
	    }
	} else {
	    mind = 0;
	}

	status = trans_data->link
	    (trans_data->data, &miss,
	     sizeof(struct x1f4_dispatch_type) + cast + mind);
	if (status) {
	    status = _libx1f4i0_lxcall_stat_link(track_data);
	    break;
	} else {
	    struct x1f4_dispatch_type *dispatch_data;
	    void *subtext;

	    dispatch_data = miss;

	    output = input[0];

	    if (cast) {
		struct x1f4_dxcast_type *dxcast_data;

		dxcast_data = (void *) (dispatch_data + 1);

		l_USER(dxcast_data, output);

		dxcast_data->call = 0;
		dxcast_data->type = type;

		output = &dxcast_data->data;
	    }

	    subtext = (void *) linetext_data->context;

	    if (mind) {
		status = _libx1f4i0_lxcall_slip_call
		    (track, function_data, offset, &linetext_data,
		     (void *) ((char *) (dispatch_data + 1) + cast), &subtext);
		if (status) {
		    break;
		}
	    }

	    dispatch_data->back = NULL;
	    dispatch_data->call = miss_call;

	    dispatch_data->transfer.context = subtext;
	    dispatch_data->transfer.function_data = &linetext_data->function;
	    dispatch_data->transfer.input = track;
	    dispatch_data->transfer.output = output;

	    input[2] = dispatch_data;
	}
    } while (0);

    return status;
}


int
_libx1f4i0_lxcall_post_call(struct x1f4_linetext_type *linetext_data,
			    const struct x1f4_function_type *function_data,
			    void *output, unsigned offset, void **input,
			    struct x1f4_trans_type *trans_data,
			    struct x1f4_iturn_type *iturn_data,
			    struct x1f4_cturn_type *cturn_data,
			    struct x1f4_track_type *track_data,
			    const struct x1f4_eelookup_type *eelookup_data)
{
    int linked, status;
    void *meta, **track;

    linked = output == x1f4_a1_walk_link;

    if (linked) {
	track = input[1];
    } else {
	track = input;
    }

    meta = *(track - 1);

    track += offset;

    status = _libx1f4i0_lxcall_even_list
	(&linetext_data->function, function_data, offset, &track, trans_data,
	 iturn_data, cturn_data, track_data, eelookup_data);
    if (status) {
    } else {
	int (*call) (void *, void **, void **,
		     const struct x1f4_function_type *, unsigned,
		     struct x1f4_trans_type *, struct x1f4_track_type *,
		     struct x1f4_linetext_type *);

	if (linked) {
	    call = slip_call;
	} else {
	    call = pick_call;
	}

	track[-1] = meta;

	status = call
	    (output, input, track, function_data, offset, trans_data,
	     track_data, linetext_data);
    }

    return status;
}
