/*
 * lxbail-a.e.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfset.h>
#include <er.h>
#include <exerrors.h>
#include <lxbail-inter.h>
#include <lxbail-types.h>

#define false(e)			0

#define lxbail(lxbail) \
    ((struct lxbail_type *) (lxbail))

int
_libx1f4i0_lxbail_stat_free(void *lxbail)
{
    LINE_EEER(lxbail(lxbail)->link_e);

    PUSH_DATA("cannot free memory", 18);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxbail_stat_fset(void *lxbail, int error)
{
    int status;

    if (false(error == X1f4_BQFSET_DECK_ERROR)) {
    } else {
	if (error == X1f4_BQFSET_FREE_ERROR) {
	    status = _libx1f4i0_lxbail_stat_free(lxbail);
	} else {
	    if (error == X1f4_BQFSET_LINK_ERROR) {
		status = _libx1f4i0_lxbail_stat_link(lxbail);
	    } else {
		if (error == X1f4_BQFSET_MODE_ERROR) {
		    status = _libx1f4i0_lxbail_stat_mode(lxbail);
		} else {
		    if (false(error == X1f4_BQFSET_TEXT_ERROR)) {
		    } else {
			/*
			 * there are defined more list error conditions...
			 */
			status = X1f4_EX_CRITICAL;
		    }
		}
	    }
	}
    }

    return status;
}


int
_libx1f4i0_lxbail_stat_link(void *lxbail)
{
    LINE_EEER(lxbail(lxbail)->link_e);

    PUSH_DATA("cannot allocate memory", 22);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}


int
_libx1f4i0_lxbail_stat_mode(void *lxbail)
{
    LINE_EEER(lxbail(lxbail)->link_e);

    PUSH_DATA("cannot reallocate memory", 24);

    POST_EEER();

    return X1f4_EX_CRITICAL;
}
