/*
 * lxbail-a.1.c
 * Copyright (C) 2011, 2012, 2013, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <bqfset.h>
#include <lxbail-inter.h>
#include <lxbail-types.h>
#include <nl.h>

int
x1f4_call_lxbail(void *lxbail, struct x1f4_nodelink_type *nodelink_data)
{
    int status;
    struct lxbail_type *lxbail_data;

    lxbail_data = lxbail;

    status = x1f4_cast_bqpset(lxbail_data->link_i.pset, nodelink_data);
    if (status) {
	if (status == X1f4_BQFSET_MISS_CLASS) {
	    status = 0;
	} else {
	    status = _libx1f4i0_lxbail_stat_fset(lxbail_data, status);
	}
    }

    return status;
}
