/*
 * lxbail-a.0.c
 * Copyright (C) 2011-2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#include <bqfset.h>
#include <e4-m.0.h>
#include <lxbail-defs.h>
#include <lxbail-types.h>
#include <trans.h>

int
x1f4_init_lxbail(void **lxbail, unsigned bits,
		 const struct screen_type *screen_data)
{
    int (*link) (void *, void **, unsigned), status;
    void *bail, *text;

    if (bits & RESOURCE_LINK) {
	link = screen_data->link_m.link;
	text = screen_data->link_m.data;
    } else {
	link = _x1f4_e4_link_data;
	text = (void *) 0;
    }

    status = link(text, &bail, sizeof(struct lxbail_type));
    if (status) {
	status = LINK_ERROR;
    } else {
	int status;
	struct lxbail_type *lxbail_data;
	struct x1f4_bqfset_type bqfset;
	struct x1f4_trans_type trans;
	unsigned flags;
	void *qset = NULL;

	lxbail_data = bail;

	if (bits & RESOURCE_LINK) {
	    bqfset.trans = &trans;

	    flags = X1f4_BQFSET_TRANS_MASK;

	    trans.data = text;
	    trans.free = screen_data->link_m.free;
	    trans.link = link;
	    trans.mode = screen_data->link_m.mode;
	} else {
	    flags = 0;
	}

	status = x1f4_init_bqfset(&qset, flags, &bqfset);
	if (status) {
	} else {
	    status = x1f4_init_bqfset(&lxbail_data->link_i.pset, 0, &bqfset);
	}
	if (status) {
	    if (qset) {
		status = x1f4_fini_bqfset(&qset);
	    }
	    if (bits & RESOURCE_LINK) {
		screen_data->link_m.free(text, bail);
	    } else {
		_x1f4_e4_free_data(text, bail);
	    }
	} else {
	    *lxbail = bail;

	    lxbail_data->link_i.tear = screen_data->link_i.tear;

	    lxbail_data->link_i.bail = screen_data->link_i.down;
	    lxbail_data->link_i.call = screen_data->link_i.down;

	    lxbail_data->link_i.qset = qset;

	    if (bits & RESOURCE_LINK) {
		lxbail_data->link_m.data = text;
		lxbail_data->link_m.free = screen_data->link_m.free;
	    } else {
		lxbail_data->link_m.free = _x1f4_e4_free_data;
	    }

	    if (bits & TEXTFLAT_LINK) {
		lxbail_data->link_e.data = screen_data->link_e.data;
		lxbail_data->link_e.line = screen_data->link_e.line;
		lxbail_data->link_e.post = screen_data->link_e.post;
		lxbail_data->link_e.push = screen_data->link_e.push;
	    } else {
		lxbail_data->link_e.data = NULL;
		lxbail_data->link_e.line = NULL;
		lxbail_data->link_e.post = NULL;
		lxbail_data->link_e.push = NULL;
	    }
	}
    }

    return status;
}
