/*
 * lstring.l.4.c
 * Copyright (C) 2011-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define C_TYPE_X(___c_type_x, ___c) \
    ((___c_type_x)[(___c) >> 5] & 1 << ((___c) & 31))

int
_libx1f4i0_side_lstring(void *data, unsigned size, unsigned *side)
{
    char *line;

    line = data;

    while (size) {
	unsigned c;

	c = *(unsigned char *) line;
	if (C_TYPE_X(side, c)) {
	    line++;
	    size--;
	} else {
	    break;
	}
    }

    return line - (char *) data;
}
