/*
 * lstring.l.1.c
 * Copyright (C) 2008-2010, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#define __DUMB_SEEK__			0
#define __ZERO_SEEK__			2

#define __HERE_SEEK__			__ZERO_SEEK__

#define ____HERE_SEEK__			__HERE_SEEK__

#if SIZEOF_VOID_P == SIZEOF_LONG
# define integral_q			unsigned long
#else
# define integral_q			unsigned
#endif				/* SIZEOF_VOID_P == SIZEOF_LONG */

#if SIZEOF_UNSIGNED_LONG == 4
# define HEAD_ZERO			0x80808080ul
# define MISS_ZERO			0x01010101ul
#else
# define HEAD_ZERO			0x8080808080808080ul
# define MISS_ZERO			0x0101010101010101ul
#endif				/* SIZEOF_UNSIGNED_LONG == 4 */

int
_libx1f4i0_down_lstring(void *data, unsigned size, unsigned down,
			unsigned *fast)
{
    char *line;
#if ____HERE_SEEK__ == __DUMB_SEEK__
#else
    unsigned slip;
#endif				/* ____HERE_SEEK__ == __DUMB_SEEK__ */

    line = (char *) data + size - 1;

#if ____HERE_SEEK__ == __DUMB_SEEK__
    while (size) {
	if (*line == down) {
	    break;
	} else {
	    line--;
	    size--;
	}
    }
#else
    slip = (integral_q) (line + 1) & (SIZEOF_UNSIGNED_LONG - 1);
    if (slip) {
	if (size < slip) {
	    slip = size;
	}

	size -= slip;

	while (slip) {
	    if (*line == down) {
		size = 0;

		break;
	    } else {
		line--;
		slip--;
	    }
	}
    }
#endif				/* ____HERE_SEEK__ == __DUMB_SEEK__ */

#if ____HERE_SEEK__ == __ZERO_SEEK__
    if (size) {
	slip = size / SIZEOF_UNSIGNED_LONG;
	if (slip) {
	    unsigned long *deck, hole;

	    hole = down & 00377;

	    hole |= hole << 010;
	    hole |= hole << 020;
# if SIZEOF_UNSIGNED_LONG == 8
	    hole |= hole << 040;
# endif				/* SIZEOF_UNSIGNED_LONG == 8 */

	    deck = (unsigned long *) (line + 1);

	    do {
		unsigned long this;

		deck--;

		this = *deck ^ hole;
		if (((this - MISS_ZERO) & ~this) & HEAD_ZERO) {
		    size = (size & (SIZEOF_UNSIGNED_LONG - 1))
			+ slip * SIZEOF_UNSIGNED_LONG;

		    line = (char *) (deck + 1) - 1;

		    break;
		} else {
		    slip--;
		    if (slip) {
		    } else {
			size = size & (SIZEOF_UNSIGNED_LONG - 1);

			line = (char *) deck - 1;

			break;
		    }
		}
	    } while (1);
	}

	if (size) {
	    do {
		if (*line == down) {
		    break;
		} else {
		    line--;
		    size--;
		}
	    } while (size);
	}
    }
#endif				/* ____HERE_SEEK__ == __ZERO_SEEK__ */

    *fast = line - (char *) data;

    return 0;
}
