/*
 * lintegral.v-w.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <lintegral.p.h>
# include <space.v.h>
#endif				/* !LIBx1f4i0 */

#define BASE_SIZE		(SIZEOF_UNSIGNED_LONG << 3)
#define SIGN_SIZE		(BASE_SIZE + 1)

int
x1f4_vprint_wlintegral(void *data,
		       int (*this) (void *, const char *, unsigned), int big,
		       unsigned w, unsigned base, long c)
{
    int status;

    do {
	char aime[SIGN_SIZE], *mode;
	unsigned size;

	mode = aime + SIGN_SIZE;
	x1f4_xprint_lintegral(&mode, big, base, c);

	size = aime + SIGN_SIZE - mode;

	if (size < w) {
	    status = x1f4_vprint_space(data, this, w - size);
	    if (status) {
		break;
	    }
	}

	status = this(data, mode, size);
    } while (0);

    return status;
}
