/*
 * lintegral.v-f.c
 * Copyright (C) 2006-2010, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <lcardinal.v-f.h>
#endif				/* !LIBx1f4i0 */

int
x1f4_vprint_flintegral(void *data,
		       int (*this) (void *, const char *, unsigned), int big,
		       unsigned f, unsigned base, long c)
{
    int status;

    if (!(c < 0)) {
	status = x1f4_vprint_flcardinal(data, this, big, f, base, c);
    } else {
	status = this(data, "-", 1);
	if (!status) {
	    status = x1f4_vprint_flcardinal(data, this, big, f, base, -c);
	}
    }

    return status;
}
