/*
 * lcardinal.v-wd.c
 * Copyright (C) 2006-2008, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <lcardinal.p-d.h>
# include <space.v.h>
#endif				/* !LIBx1f4i0 */

#define BASE_SIZE		(SIZEOF_UNSIGNED_LONG << 3)

int
x1f4_vprint_wdlcardinal(void *data,
			int (*this) (void *, const char *, unsigned),
			unsigned w, unsigned long c)
{
    int status;

    do {
	char aime[BASE_SIZE], *mode;
	unsigned size;

	mode = aime + BASE_SIZE;
	x1f4_xprint_dlcardinal(&mode, c);

	size = aime + BASE_SIZE - mode;

	if (size < w) {
	    status = x1f4_vprint_space(data, this, w - size);
	    if (status) {
		break;
	    }
	}

	status = this(data, mode, size);
    } while (0);

    return status;
}
