/*
 * lcardinal.v-f.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <lcardinal.p-f.h>
# include <zero-prefix.v.h>
#endif				/* !LIBx1f4i0 */

#define BASE_SIZE		(SIZEOF_UNSIGNED_LONG << 3)

int
x1f4_vprint_flcardinal(void *data,
		       int (*this) (void *, const char *, unsigned), int big,
		       unsigned f, unsigned base, unsigned long c)
{
    int status;

    do {
	char aime[BASE_SIZE], *mode;

	if (BASE_SIZE < f) {
	    status = x1f4_vprint_0prefix(data, this, f - BASE_SIZE);
	    if (status) {
		break;
	    } else {
		f = BASE_SIZE;
	    }
	}

	mode = aime + BASE_SIZE;
	x1f4_xprint_flcardinal(&mode, big, f, base, c);

	status = this(data, mode, aime + BASE_SIZE - mode);
    } while (0);

    return status;
}
