/*
 * lcardinal.p-fd.c
 * Copyright (C) 2002-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

static const char digits[] = "0123456789";

void
x1f4_xprint_fdlcardinal(char **output, unsigned f, unsigned long c)
{
    char *o;

    o = *output;

    if (!f) {
	do {
	    --o;
	    *o = digits[c % 10];
	    c /= 10;
	} while (c);
    } else {
	while (1) {
	    --o;
	    *o = digits[c % 10];
	    c /= 10;
	    if (f) {
		f--;
	    }
	    if (!(c | f)) {
		break;
	    }
	}
    }

    *output = o;
}
