/*
 * lcardinal.c
 * Copyright (C) 2006-2008, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <limits.h>

#if defined LIBx1f4i0
# include <ctype.0.h>
#endif				/* LIBx1f4i0 */

#define __DUMB_11__			0
#define __TYPE_11__			1

#define __THIS_11__			__TYPE_11__

#if !defined LIBx1f4i0
# define C_TYPE_X(c_type_x, c) \
    ((c_type_x)[(c) >> 5] & 1 << ((c) & 31))
#endif				/* !LIBx1f4i0 */

#if __THIS_11__ == __TYPE_11__
# if 0
/* *INDENT-OFF* */
static const char base_11[] =
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
				    "0000000000\0\0\0\0\0\0"
    "\0"
      "77777777777777777777777777\0\0\0\0\0"
    "\0WWWWWWWWWWWWWWWWWWWWWWWWWW\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
/* *INDENT-ON* */
# else
/* *INDENT-OFF* */
static const char base_11[] =
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\1\2\3\4\5\6\7\10\11\0\0\0\0\0\0"
    "\0\12\13\14\15\16\17\20\21\22\23\24\25\26\27\30"
    "\31\32\33\34\35\36\37\40\41\42\43\0\0\0\0\0"
    "\0\12\13\14\15\16\17\20\21\22\23\24\25\26\27\30"
    "\31\32\33\34\35\36\37\40\41\42\43\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
    "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
/* *INDENT-ON* */
# endif				/* 0 */
#endif				/* __THIS_11__ == __TYPE_11__ */

int
x1f4_parse_lcardinal(unsigned long *cardinal, const char *s, const char **e,
		     unsigned base)
{
    int status = 0;

    if (base < 11) {
	int c;
	unsigned c_type_2[8];

	c_type_2[0] = 0;
	c_type_2[1] = ((1 << base) - 1) << 16;
	c_type_2[2] = 0;
	c_type_2[3] = 0;
	c_type_2[4] = 0;
	c_type_2[5] = 0;
	c_type_2[6] = 0;
	c_type_2[7] = 0;

	c = *(const unsigned char *) s;
	if (!C_TYPE_X(c_type_2, c)) {
	    status = 1;
	} else {
	    unsigned long a, l = 0;

	    a = ULONG_MAX / base + 1;

	    do {
		if (l < a) {
		    l *= base;
		} else {
		    l = ULONG_MAX;
		}
		c -= '0';
		if (l < ULONG_MAX - c) {
		    l += c;
		} else {
		    l = ULONG_MAX;
		}
		s++;
		c = *(const unsigned char *) s;
	    } while (C_TYPE_X(c_type_2, c));
	    if (c) {
		status = 1;
	    }

	    *cardinal = l;
	}
    } else {
#if __THIS_11__ == __DUMB_11__
	int c, lower, upper;

	lower = 0x57 + base;
	upper = 0x37 + base;

	c = *(const unsigned char *) s;
	if (0x2f < c && c < 0x3a) {
	    c -= 0x30;
	} else if (0x40 < c && c < upper) {
	    c -= 0x37;
	} else if (0x60 < c && c < lower) {
	    c -= 0x57;
	} else {
	    status = 1;
	}
	if (!status) {
	    unsigned long a, l;

	    a = ULONG_MAX / base + 1;

	    l = c;
	    while (1) {
		s++;
		c = *(const unsigned char *) s;
		if (0x2f < c && c < 0x3a) {
		    c -= 0x30;
		    if (l < a) {
			l *= base;
		    } else {
			l = ULONG_MAX;
		    }
		    if (l < ULONG_MAX - c) {
			l += c;
		    } else {
			l = ULONG_MAX;
		    }
		} else if (0x40 < c && c < upper) {
		    c -= 0x37;
		    if (l < a) {
			l *= base;
		    } else {
			l = ULONG_MAX;
		    }
		    if (l < ULONG_MAX - c) {
			l += c;
		    } else {
			l = ULONG_MAX;
		    }
		} else if (0x60 < c && c < lower) {
		    c -= 0x57;
		    if (l < a) {
			l *= base;
		    } else {
			l = ULONG_MAX;
		    }
		    if (l < ULONG_MAX - c) {
			l += c;
		    } else {
			l = ULONG_MAX;
		    }
		} else {
		    if (c) {
			status = 1;
		    }
		    break;
		}
	    }

	    *cardinal = l;
	}
#else
	int c;
	unsigned c_type_2[8];

	c_type_2[0] = 0;
	c_type_2[1] = ((1 << 10) - 1) << 16;
	c_type_2[2] = ((1 << (base - 10)) - 1) << 1;
	c_type_2[3] = c_type_2[2];
	c_type_2[4] = 0;
	c_type_2[5] = 0;
	c_type_2[6] = 0;
	c_type_2[7] = 0;

	c = *(const unsigned char *) s;
	if (!C_TYPE_X(c_type_2, c)) {
	    status = 1;
	} else {
	    unsigned long a, l = 0;

	    a = ULONG_MAX / base + 1;

	    do {
		if (l < a) {
		    l *= base;
		} else {
		    l = ULONG_MAX;
		}
		c = base_11[c];
		if (l < ULONG_MAX - c) {
		    l += c;
		} else {
		    l = ULONG_MAX;
		}
		s++;
		c = *(const unsigned char *) s;
	    } while (C_TYPE_X(c_type_2, c));
	    if (c) {
		status = 1;
	    }

	    *cardinal = l;
	}
#endif				/* __THIS_11__ == __DUMB_11__ */
    }

    if (e) {
	*e = s;
    }

    return status;
}
