/*
 * lcardinal-d.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <limits.h>

#if defined LIBx1f4i0
# include <ctype.0.h>
#endif				/* LIBx1f4i0 */

#if !defined LIBx1f4i0
# define C_TYPE_X(c_type_x, c) \
    ((c_type_x)[(c) >> 5] & 1 << ((c) & 31))
#endif				/* !LIBx1f4i0 */

static const unsigned c_type_2[] = {
/*
 *
 *
 *
 * 0 1 2 3 4 5 6 7 8 9
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff0000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

int
x1f4_parse_dlcardinal(unsigned long *cardinal, const char *s, const char **e)
{
    int c, status = 0;

    c = *(const unsigned char *) s;
    if (!C_TYPE_X(c_type_2, c)) {
	status = 1;
    } else {
	unsigned long l = 0;

	do {
	    if (l < ULONG_MAX / 10) {
		l *= 10;
	    } else {
		l = ULONG_MAX;
	    }
	    c -= '0';
	    if (l < ULONG_MAX - c) {
		l += c;
	    } else {
		l = ULONG_MAX;
	    }
	    s++;
	    c = *(const unsigned char *) s;
	} while (C_TYPE_X(c_type_2, c));
	if (c) {
	    status = 1;
	}

	*cardinal = l;
    }

    if (e) {
	*e = s;
    }

    return status;
}
