/*
 * ixx.1.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <c1.h>
#include <e42.h>
#include <ix-types.h>

int
x1f4_xset_program(struct x1f4_c1_type *c1_data, unsigned *bits,
		  struct indexset_type *indexset_data)
{
    c1_data->function_set.fix = x1f4_fix_function;
    c1_data->function_set.get = x1f4_get_function;
    c1_data->function_set.context = indexset_data->function_set.text;
    c1_data->datatype_set.miss = indexset_data->datatype_set.datatype_data;
    c1_data->operator1s = indexset_data->operator_set.operator1s;
    c1_data->operator2s = indexset_data->operator_set.operator2s;
    c1_data->transfer_set.fine = indexset_data->transfer_set.fine;
    c1_data->variable_set.context = indexset_data->variable_set.text;

    *bits = X1f4_C1_DDACCESS | X1f4_C1_SCOMMENT | X1f4_C1_TRANSFER
	| X1f4_C1_TYPELIST;

    return 0;
}
