/*
 * ixx.0.c
 * Copyright (C) 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <a1.h>
#include <e42.h>
#include <e4less.h>
#include <ix-types.h>

int
x1f4_xset_shuffle(struct x1f4_a1_type *a1_data, unsigned *bits,
		  struct indexset_type *indexset_data)
{
    a1_data->autolead_set.context = indexset_data->autodeck_set.less;
    a1_data->autolead_set.link = x1f4_link_e4lf;
    a1_data->autolead_set.pick = x1f4_pick_e4lf;
    a1_data->autolink_set = indexset_data->autolink_set;
    a1_data->datatype_set.miss = indexset_data->datatype_set.datatype_data;
    a1_data->eelookup_set.eelookup_data =
	&indexset_data->eelookup_set.eelookup;
    a1_data->function_set.fix = x1f4_fix_function;
    a1_data->function_set.get = x1f4_get_function;
    a1_data->function_set.context = indexset_data->function_set.text;
    a1_data->operator1s = indexset_data->operator_set.operator1s;
    a1_data->operator2s = indexset_data->operator_set.operator2s;
    a1_data->transfer_set.fine = indexset_data->transfer_set.fine;
    a1_data->variable_set.context = indexset_data->variable_set.text;

    *bits = X1f4_A1_CASTTYPE | X1f4_A1_DDACCESS | X1f4_A1_EELOOKUP
	| X1f4_A1_LEADCAST | X1f4_A1_SCOMMENT | X1f4_A1_TRANSFER
	| X1f4_A1_TYPELIST;

    return 0;
}
