/*
 * iname.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ctype.0.h>

extern const unsigned _x1f4_c_type_0[], _x1f4_c_type_1[];

int
x1f4_check_identifier(const char *name)
{
    int c, status = 0;

    c = *(const unsigned char *) name;
    if (!C_TYPE_X(_x1f4_c_type_1, c)) {
	status = 1;
    } else {
	name++;
	c = *(const unsigned char *) name;
	while (c) {
	    if (!C_TYPE_X(_x1f4_c_type_0, c)) {
		status = 1;
		break;
	    }
	    name++;
	    c = *(const unsigned char *) name;
	}
    }

    return status;
}
