/*
 * identifier.c
 * Copyright (C) 2006-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if defined LIBx1f4i0
# include <ctype.0.h>
#endif				/* LIBx1f4i0 */

#if !defined LIBx1f4i0
# define C_TYPE_X(c_type_x, c) \
    ((c_type_x)[(c) >> 5] & 1 << ((c) & 31))
#endif				/* !LIBx1f4i0 */

const unsigned c_type_0[] = {
/*
 *
 *
 *
 * 0 1 2 3 4 5 6 7 8 9
 *   A B C D E F G H I J K L M N O
 * P Q R S T U V W X Y Z         _
 *   a b c d e f g h i j k l m n o
 * p q r s t u v w x y z
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x03ff0000, 0x87fffffe, 0x07fffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
}, c_type_1[] = {
/*
 *
 *
 *
 *
 *   A B C D E F G H I J K L M N O
 * P Q R S T U V W X Y Z         _
 *   a b c d e f g h i j k l m n o
 * p q r s t u v w x y z
 *
 *
 *
 *
 *
 *
 *
 *
 */
/* *INDENT-OFF* */
    0x00000000, 0x00000000, 0x87fffffe, 0x07fffffe,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
/* *INDENT-ON* */
};

int
x1f4_test_identifier(const char *s)
{
    int c, status = 1;

    c = *(const unsigned char *) s;
    if (C_TYPE_X(c_type_1, c)) {
	do {
	    s++;
	    c = *(const unsigned char *) s;
	} while (C_TYPE_X(c_type_0, c));
	if (!c) {
	    status = 0;
	}
    }

    return status;
}
