/*
 * float.v.c
 * Copyright (C) 2006-2007, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stddef.h>

#if !defined LIBx1f4i0
# include <float.e.h>
#endif				/* !LIBx1f4i0 */
#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */

int
x1f4_vprint_float(void *data, int (*this) (void *, const char *, unsigned),
		  unsigned precision, double value)
{
    char buffer[312], *string;
    unsigned length;

    length = x1f4_eprint_cfloat(buffer, precision, value, NULL, &string);

    return this(data, string, length);
}
