/*
 * float.v-pw.c
 * Copyright (C) 2006-2010, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined LIBx1f4i0
# include <float.e.h>
#endif				/* !LIBx1f4i0 */
#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */
#if !defined LIBx1f4i0
# include <space.v.h>
#endif				/* !LIBx1f4i0 */

int
x1f4_vprint_pwfloat(void *data, int (*this) (void *, const char *, unsigned),
		    int alignment, unsigned width, unsigned Precision,
		    unsigned precision, double value)
{
    char buffer[312], *string;
    int status;
    unsigned diff = 0, digits, length;

    length = x1f4_eprint_cfloat(buffer, precision, value, &digits, &string);

    if (digits < Precision) {
	diff = Precision - digits;
	if (digits) {
	} else {
	    diff++;
	}
	if (width < length) {
	    width = 0;
	} else {
	    if (alignment) {
		alignment = 0;
		if (length + diff < width) {
		    diff = width - length;
		}
		width = 0;
	    } else {
		if (diff < width) {
		    width -= diff;
		} else {
		    width = 0;
		}
	    }
	}
    }
    if (length < width) {
	if (alignment) {
	    status = this(data, string, length);
	    if (status) {
	    } else {
		status = x1f4_vprint_space(data, this, width - length);
	    }
	} else {
	    status = x1f4_vprint_space(data, this, width - length);
	    if (status) {
	    } else {
		status = this(data, string, length);
	    }
	}
    } else {
	status = this(data, string, length);
    }
    if (status) {
    } else {
	if (diff) {
	    status = x1f4_vprint_space(data, this, diff);
	}
    }

    return status;
}
