/*
 * float.n.c
 * Copyright (C) 2002-2012, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <math.h>
#include <stddef.h>
#include <string.h>

#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */

#define LOG_10_BY_LOG_2_TIMES_65536	217706

void
x1f4_nprint_cfloat(unsigned *put, unsigned precision, double value,
		   unsigned *c_digits)
{
    unsigned digits = 0, wide_length = 0;

    if (finite(value)) {
	int zero = 0;

	if (value) {
	    int exponent;
	    unsigned bits[2], fractional_digits, integral_digits, length = 0,
		sign;

	    if (1) {
		unsigned *slip;

		slip = (void *) &value;
#if WORDS_BIGENDIAN
		bits[0] = slip[0];
		bits[1] = slip[1];
#else
		bits[0] = slip[1];
		bits[1] = slip[0];
#endif				/* WORDS_BIGENDIAN */
	    }

	    sign = bits[0] & (1 << 31);
	    exponent = (int) ((bits[0] >> 20) & 0x7ff) - 1022;

	    integral_digits = 0 < exponent ? exponent : 0;
	    if (integral_digits) {
		unsigned left, mantissa_integral_digits, offset = 53, units;
		unsigned short kbit[64], *mantissa;

		mantissa_integral_digits =
		    integral_digits < 53 ? integral_digits : 53;
		mantissa = (unsigned short *) &kbit
		    + ((1024 - integral_digits) >> 4);
		units = 64 - (mantissa - (unsigned short *) &kbit);

		bits[0] &= ~0 >> 12;
		bits[0] |= 1 << 20;
		left = integral_digits;
		memset(kbit, '\0', 128);
		while (mantissa_integral_digits) {
		    unsigned transfer;

		    transfer = left & 15;
		    if (!transfer) {
			transfer = 16;
		    }
		    if (offset < transfer) {
			transfer = offset;
		    } else if (32 < offset && offset - transfer < 32) {
			transfer = offset - 32;
		    }
		    mantissa_integral_digits -= transfer;
		    offset -= transfer;
		    left -= transfer;
		    *mantissa |= ((bits[31 < offset ? 0 : 1] >> (offset & 31))
				  & ((1 << transfer) - 1)) << (left & 15);
		    if (!(left & 15)) {
			mantissa++;
		    }
		}

		mantissa = (unsigned short *) &kbit + 64 - units;
		while (units) {
		    unsigned decrement = 0, transfer = 0;

		    for (left = units; left; left--) {
			unsigned quotient;

			transfer |= mantissa[units - left];
			quotient = transfer / 10;
			if (quotient || left != units) {
			    mantissa[units - left] = quotient;
			} else {
			    decrement = 1;
			}
			transfer %= 10;
			if (left == 1) {
			    length++;
			} else {
			    transfer <<= 16;
			}
		    }

		    if (decrement) {
			units--;
			mantissa++;
		    }
		}
	    }

	    fractional_digits =
		integral_digits < 53 ? 53 - integral_digits : 0;
	    if (fractional_digits && precision) {
		unsigned left, mantissa_fractional_digits,
		    max_fractional_digits, nines = 0, offset = 53, slip, track,
		    trailing = 0, units;
		unsigned short thousand_eighty_eight_bit[68], *mantissa;

		mantissa_fractional_digits = fractional_digits;
		left = exponent < 0 ? -exponent : 0;
		mantissa =
		    (unsigned short *) thousand_eighty_eight_bit + (left >> 4);

		bits[0] &= ~0 >> 12;
		bits[0] |= 1 << 20;
		memset(thousand_eighty_eight_bit, '\0', 136);
		offset -= integral_digits;
		while (mantissa_fractional_digits) {
		    unsigned transfer;

		    transfer = ((left ^ 15) & 15) + 1;
		    if (!transfer) {
			transfer = 16;
		    }
		    if (offset < transfer) {
			transfer = offset;
		    } else {
			if (32 < offset && offset - transfer < 32) {
			    transfer = offset - 32;
			}
		    }
		    mantissa_fractional_digits -= transfer;
		    offset -= transfer;
		    left += transfer;
		    *mantissa |= ((bits[31 < offset ? 0 : 1] >> (offset & 31))
				  & ((1 << transfer) - 1))
			<< (((left ^ 15) + 1) & 15);
#if 0
                        & ((1 << transfer) - 1)) << ((16 - left % 16) % 16);
#endif				/* 0 */
		    if (left & 15) {
		    } else {
			mantissa++;
		    }
		}
		units = mantissa - thousand_eighty_eight_bit;

		track = left;
		slip = 0;

		mantissa = thousand_eighty_eight_bit;
		max_fractional_digits = 309 - length;
		fractional_digits = 0;
		while (~units && precision
		       && fractional_digits != max_fractional_digits) {
		    int b0 = 1, bf = 1;
		    unsigned decrement = 0, f = 0, transfer = 0;

		    precision--;

		    slip += LOG_10_BY_LOG_2_TIMES_65536;

		    for (left = units; ~left; left--) {
			unsigned m, s;

			m = mantissa[left];
			f |= m;
			transfer += m * 10;
			if (transfer & 65535 || left != units) {
			    mantissa[left] = transfer;
			} else {
			    decrement = 1;
			}
			transfer >>= 16;

			s = slip >> 16;
			if (s < track) {
			    s = track - s;
			    if (left << 4 < s) {
				unsigned z = 65535;

				m = mantissa[left];

				s -= left << 4;
				if (s < 16) {
				    z <<= 16 - s;
				    z &= 65535;
				    m &= z;
				} else {
				}

				if (m) {
				    b0 = 0;
				    if (m ^ z) {
					bf = 0;
				    }
				} else {
				    bf = 0;
				}
			    }
			}
		    }
		    if (f) {
		    } else {
			break;
		    }

		    fractional_digits++;

		    if (bf) {
			trailing = 0;

			if (transfer ^ 9) {
			    break;
			} else {
			    nines++;
			    if (nines ^ fractional_digits) {
				fractional_digits -= nines;
				if (1) {
				    break;
				}
			    }
			}
		    } else {
			if (transfer) {
			    trailing = 0;
			} else {
			    trailing++;
			}

			if (b0) {
			    break;
			}

			if (transfer ^ 9) {
			    nines = 0;
			} else {
			    nines++;
			}
		    }

		    if (slip >> 16 < track) {
		    } else {
			break;
		    }

		    if (decrement) {
			units--;
		    }
		}

		if (precision && trailing) {
		    fractional_digits -= trailing;
		}
	    } else {
		fractional_digits = 0;
	    }

	    length += fractional_digits;

	    if (length) {
		if (sign) {
		    length++;
		}
		if (fractional_digits) {
		    length++;
		}
		wide_length = length;

		digits = fractional_digits;
	    } else {
		zero = 1;
	    }
	} else {
	    zero = 1;
	}
	if (!zero) {
	} else {
	    unsigned *b_value;

	    b_value = (void *) &value;
#if WORDS_BIGENDIAN
	    if (*b_value & (1 << 31)) {
#elif 0
	    }
#else
	    if (b_value[1] & (1 << 31)) {
#endif				/* WORDS_BIGENDIAN */
		wide_length = 2;
	    } else {
		wide_length = 1;
	    }
	}
    } else {
	if (isnan(value)) {
	    wide_length = 3;
	} else {
	    if (value < 0) {
		wide_length = 4;
	    } else {
		wide_length = 3;
	    }
	}
    }

    if (c_digits) {
	*c_digits = digits;
    }

    *put += wide_length;
}


void
x1f4_nprint_float(unsigned *put, unsigned precision, double value)
{
    x1f4_nprint_cfloat(put, precision, value, NULL);
}
