/*
 * float.c
 * Copyright (C) 2002-2007, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <config.h>

#include <stddef.h>
#include <string.h>

#if !defined LIBx1f4i0
# include <float.e.h>
#endif				/* !LIBx1f4i0 */
#if defined LIBx1f4i0
# include <inter.h>
#endif				/* LIBx1f4i0 */

int
x1f4_xprint_cfloat(char *output, unsigned precision, double value,
		   unsigned *c_digits)
{
    char *string, wide_buffer[312];
    unsigned wide_length;

    wide_length = x1f4_eprint_cfloat
	(wide_buffer, precision, value, c_digits, &string);

    memcpy(output, string, wide_length + 1);

    return wide_length;
}


int
x1f4_xprint_float(char *output, unsigned precision, double value)
{
    return x1f4_xprint_cfloat(output, precision, value, NULL);
}
