/*
 * file.o.x.c
 * Copyright (C) 2010, 2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <file-types.h>

#define file(file) \
    ((struct aofile_type *) (file))

extern const struct sffile_type _libx1f4_file_o_sjfile, _libx1f4_file_o_sffile;

int
_libx1f4i0_ever_ofile(void *file, int *fd)
{
    int status = 0;

    if (file(file)->sf == &_libx1f4_file_o_sffile) {
	*fd = *(int *) &file(file)->sd;
    } else {
	if (file(file)->sf == &_libx1f4_file_o_sjfile) {
	    *fd = ((struct ajfile_type *) &file(file)->sd)->fd;
	} else {
	    status = -1;
	}
    }

    return status;
}
