/*
 * file.o.p.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <unistd.h>

#include <file-defs.h>
#include <file-types.h>

#define data(file, offset) \
    ((char *) (file(file) + 1) + (offset))

#define file(file) \
    ((struct aofile_type *) (file))

extern const struct sffile_type _libx1f4_file_o_sjfile;

int
_libx1f4i0_long_ofile(void *file)
{
    int status;

    if (file(file)->sf != &_libx1f4_file_o_sjfile) {
	status = TYPE_CLASS;
    } else {
	struct ajdata_type *ajdata_data;
	struct ajfile_type *ajfile_data;

	ajfile_data = (void *) &file(file)->sd;
	ajdata_data = ajfile_data->last;
	if (ajdata_data) {
	    struct ajdata_type *ajdata_last;
	    unsigned size, slip;
	    void *data;

	    slip = ajfile_data->slip;

	    data = ajdata_data + 1;
	    data = (char *) data + slip;

	    ajdata_last = ajdata_data->last;

	    size = CALL_SIZE - slip;

	    if (ajdata_last) {
	    } else {
		size -= ajfile_data->lead;
	    }

	    status = write(ajfile_data->fd, data, size);
	    if (status == -1) {
		if (errno == EINTR) {
		    status = 0;
		} else {
		    status = PUSH_CLASS;
		}
	    } else {
		if (status != size) {
		    ajfile_data->slip = slip + status;
		    if (1) {
			status = 0;
		    }
		} else {
		    struct trans_type *trans_data;

		    trans_data = ajfile_data->trans;

		    status = trans_data->free(trans_data->data, ajdata_data);
		    if (status) {
			status = FREE_CLASS;
		    } else {
			if (ajdata_last) {
			    ajfile_data->last = ajdata_last;
			    ajfile_data->slip = 0;
			} else {
			    ajfile_data->lead = 0;
			    ajfile_data->slip = 0;
			    ajfile_data->last = NULL;
			    ajfile_data->next = NULL;
			}
		    }
		}
	    }
	} else {
	    unsigned miss;
	    void *slip;

	    miss = file(file)->size;

	    slip = data(file, file(file)->ever);

	    status = write(ajfile_data->fd, slip, miss);
	    if (status == -1) {
		if (errno == EINTR) {
		} else {
		    status = PUSH_CLASS;
		}
	    } else {
		miss -= status;

		file(file)->size = miss;

		if (miss) {
		    file(file)->ever += status;
		    if (1) {
			status = 0;
		    }
		} else {
		    status = OVER_CLASS;
		}
	    }
	}
    }

    return status;
}
