/*
 * file.o.n.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <fcntl.h>
#include <stddef.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-defs.h>
#include <file-types.h>

#define file(file) \
    ((struct ajfile_type *) (file))

static int fine_file(void *);
static int lose_file(void *);
static int push_file(void *, void *, unsigned);

static off_t seek_file(void *, off_t, int);

const struct sffile_type _libx1f4_file_o_sjfile = {
/* *INDENT-OFF* */
    fine_file,
    lose_file,
    NULL,
    push_file,
    seek_file
/* *INDENT-ON* */
};

static int
fine_file(void *file)
{
    return fcntl(file(file)->fd, F_SETFD, FD_CLOEXEC);
}


static int
lose_file(void *file)
{
    int status = 0;
    struct ajdata_type *next;

    next = file(file)->next;
    if (next) {
	int (*free) (void *, void *);
	struct trans_type *trans_data;
	void *data;

	trans_data = file(file)->trans;

	data = trans_data->data;
	free = trans_data->free;

	do {
	    int excess;
	    struct ajdata_type *slip;

	    slip = next;
	    next = next->next;

	    excess = free(data, slip);
	    if (excess) {
		errno = EINVAL;
		status = -1;
	    }
	} while (next);
    }

    if (close(file(file)->fd)) {
	status = -1;
    }

    return status;
}


static int
push_file(void *file, void *flat, unsigned size)
{
    int (*link) (void *, void **, unsigned), status = 0;
    struct ajdata_type *next;
    struct trans_type *trans_data;
    unsigned lead, push;
    void *data;

    trans_data = file(file)->trans;

    data = trans_data->data;
    link = trans_data->link;

    lead = file(file)->lead;

    next = file(file)->next;

    push = size;
    while (push) {
	unsigned call;

	if (lead) {
	} else {
	    void *fine;

	    status = link(data, &fine, sizeof(struct ajdata_type) + CALL_SIZE);
	    if (status) {
		errno = ENOMEM;
		status = -1;
		if (1) {
		    break;
		}
	    } else {
		struct ajdata_type *fare;

		lead = CALL_SIZE;

		fare = fine;

		fare->last = NULL;
		fare->next = next;

		if (next) {
		    next->last = fare;
		} else {
		    file(file)->last = fare;
		}

		next = fare;
	    }
	}

	call = push;
	if (lead < call) {
	    call = lead;
	}

	memcpy((char *) (next + 1) + CALL_SIZE - lead, flat, call);

	lead -= call;

	push -= call;
	flat = (char *) flat + call;
    }

    file(file)->next = next;

    file(file)->lead = lead;

    if (status) {
    } else {
	status = size;
    }

    return status;
}


static off_t
seek_file(void *file, off_t offset, int whence)
{
    return -1;
}
