/*
 * file.o.9.c
 * Copyright (C) 2008-2011, 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <fcntl.h>
#include <stddef.h>

#include <file-defs.h>
#include <file-types.h>
#include <trans.h>

#define file(file) \
    ((struct aofile_type *) (file))

extern const struct sffile_type _libx1f4_file_o_sjfile;

int
_libx1f4i0_fare_ofile(void *file, const char *path, unsigned bits,
		      unsigned mode, struct x1f4_trans_type *trans_data)
{
    int fd, status;

    fd = open(path, bits, mode);
    if (fd == -1) {
	status = OPEN_CLASS;
    } else {
	struct ajfile_type *ajfile_data;

	status = 0;

	ajfile_data = (void *) &file(file)->sd;

	ajfile_data->fd = fd;

	ajfile_data->lead = 0;
	ajfile_data->slip = 0;

	ajfile_data->last = NULL;
	ajfile_data->next = NULL;

	ajfile_data->trans = trans_data;

	file(file)->ever = 0;
	file(file)->size = 0;

	file(file)->sf = &_libx1f4_file_o_sjfile;
    }

    return status;
}
