/*
 * file.i.j.c
 * Copyright (C) 2013, 2014, Ciprian Niculescu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <fcntl.h>
#include <stddef.h>
#include <unistd.h>

#include <sys/types.h>

#include <file-types.h>

static int fine_file(void *);
static int lose_file(void *);
static int pull_file(void *, void *, unsigned);

static off_t seek_file(void *, off_t, int);

const struct sffile_type _libx1f4_file_i_sffile = {
/* *INDENT-OFF* */
    fine_file,
    lose_file,
    pull_file,
    NULL,
    seek_file
/* *INDENT-ON* */
};

static int
fine_file(void *file)
{
    return fcntl(*(int *) file, F_SETFD, FD_CLOEXEC);
}


static int
lose_file(void *file)
{
    return close(*(int *) file);
}


static int
pull_file(void *file, void *flat, unsigned size)
{
    return read(*(int *) file, flat, size);
}


static off_t
seek_file(void *file, off_t offset, int whence)
{
    return lseek(*(int *) file, offset, whence);
}
